// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewStage;
import com.microsoft.graph.models.AccessReviewStageFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AccessReviewInstanceDecisionItemCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewInstanceDecisionItemRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Stage Request.
 */
public class AccessReviewStageRequest extends BaseRequest<AccessReviewStage> {
	
    /**
     * The request for the AccessReviewStage
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewStageRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewStage.class);
    }

    /**
     * Gets the AccessReviewStage from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewStage> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessReviewStage from the service
     *
     * @return the AccessReviewStage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewStage get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewStage> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessReviewStage delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessReviewStage with a source
     *
     * @param sourceAccessReviewStage the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewStage> patchAsync(@Nonnull final AccessReviewStage sourceAccessReviewStage) {
        return sendAsync(HttpMethod.PATCH, sourceAccessReviewStage);
    }

    /**
     * Patches this AccessReviewStage with a source
     *
     * @param sourceAccessReviewStage the source object with updates
     * @return the updated AccessReviewStage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewStage patch(@Nonnull final AccessReviewStage sourceAccessReviewStage) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessReviewStage);
    }

    /**
     * Creates a AccessReviewStage with a new object
     *
     * @param newAccessReviewStage the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewStage> postAsync(@Nonnull final AccessReviewStage newAccessReviewStage) {
        return sendAsync(HttpMethod.POST, newAccessReviewStage);
    }

    /**
     * Creates a AccessReviewStage with a new object
     *
     * @param newAccessReviewStage the new object to create
     * @return the created AccessReviewStage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewStage post(@Nonnull final AccessReviewStage newAccessReviewStage) throws ClientException {
        return send(HttpMethod.POST, newAccessReviewStage);
    }

    /**
     * Creates a AccessReviewStage with a new object
     *
     * @param newAccessReviewStage the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewStage> putAsync(@Nonnull final AccessReviewStage newAccessReviewStage) {
        return sendAsync(HttpMethod.PUT, newAccessReviewStage);
    }

    /**
     * Creates a AccessReviewStage with a new object
     *
     * @param newAccessReviewStage the object to create/update
     * @return the created AccessReviewStage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewStage put(@Nonnull final AccessReviewStage newAccessReviewStage) throws ClientException {
        return send(HttpMethod.PUT, newAccessReviewStage);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewStageRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewStageRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

