// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MailSearchFolder;
import com.microsoft.graph.models.MailFolder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mail Search Folder Request.
 */
public class MailSearchFolderRequest extends BaseRequest<MailSearchFolder> {
	
    /**
     * The request for the MailSearchFolder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MailSearchFolderRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MailSearchFolder.class);
    }

    /**
     * Gets the MailSearchFolder from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MailSearchFolder> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MailSearchFolder from the service
     *
     * @return the MailSearchFolder from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MailSearchFolder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MailSearchFolder> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MailSearchFolder delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MailSearchFolder with a source
     *
     * @param sourceMailSearchFolder the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MailSearchFolder> patchAsync(@Nonnull final MailSearchFolder sourceMailSearchFolder) {
        return sendAsync(HttpMethod.PATCH, sourceMailSearchFolder);
    }

    /**
     * Patches this MailSearchFolder with a source
     *
     * @param sourceMailSearchFolder the source object with updates
     * @return the updated MailSearchFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MailSearchFolder patch(@Nonnull final MailSearchFolder sourceMailSearchFolder) throws ClientException {
        return send(HttpMethod.PATCH, sourceMailSearchFolder);
    }

    /**
     * Creates a MailSearchFolder with a new object
     *
     * @param newMailSearchFolder the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MailSearchFolder> postAsync(@Nonnull final MailSearchFolder newMailSearchFolder) {
        return sendAsync(HttpMethod.POST, newMailSearchFolder);
    }

    /**
     * Creates a MailSearchFolder with a new object
     *
     * @param newMailSearchFolder the new object to create
     * @return the created MailSearchFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MailSearchFolder post(@Nonnull final MailSearchFolder newMailSearchFolder) throws ClientException {
        return send(HttpMethod.POST, newMailSearchFolder);
    }

    /**
     * Creates a MailSearchFolder with a new object
     *
     * @param newMailSearchFolder the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MailSearchFolder> putAsync(@Nonnull final MailSearchFolder newMailSearchFolder) {
        return sendAsync(HttpMethod.PUT, newMailSearchFolder);
    }

    /**
     * Creates a MailSearchFolder with a new object
     *
     * @param newMailSearchFolder the object to create/update
     * @return the created MailSearchFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MailSearchFolder put(@Nonnull final MailSearchFolder newMailSearchFolder) throws ClientException {
        return send(HttpMethod.PUT, newMailSearchFolder);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MailSearchFolderRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MailSearchFolderRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

