// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MuteParticipantOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mute Participant Operation Request.
 */
public class MuteParticipantOperationRequest extends BaseRequest<MuteParticipantOperation> {
	
    /**
     * The request for the MuteParticipantOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MuteParticipantOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MuteParticipantOperation.class);
    }

    /**
     * Gets the MuteParticipantOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MuteParticipantOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MuteParticipantOperation from the service
     *
     * @return the MuteParticipantOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MuteParticipantOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MuteParticipantOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MuteParticipantOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MuteParticipantOperation with a source
     *
     * @param sourceMuteParticipantOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MuteParticipantOperation> patchAsync(@Nonnull final MuteParticipantOperation sourceMuteParticipantOperation) {
        return sendAsync(HttpMethod.PATCH, sourceMuteParticipantOperation);
    }

    /**
     * Patches this MuteParticipantOperation with a source
     *
     * @param sourceMuteParticipantOperation the source object with updates
     * @return the updated MuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MuteParticipantOperation patch(@Nonnull final MuteParticipantOperation sourceMuteParticipantOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceMuteParticipantOperation);
    }

    /**
     * Creates a MuteParticipantOperation with a new object
     *
     * @param newMuteParticipantOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MuteParticipantOperation> postAsync(@Nonnull final MuteParticipantOperation newMuteParticipantOperation) {
        return sendAsync(HttpMethod.POST, newMuteParticipantOperation);
    }

    /**
     * Creates a MuteParticipantOperation with a new object
     *
     * @param newMuteParticipantOperation the new object to create
     * @return the created MuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MuteParticipantOperation post(@Nonnull final MuteParticipantOperation newMuteParticipantOperation) throws ClientException {
        return send(HttpMethod.POST, newMuteParticipantOperation);
    }

    /**
     * Creates a MuteParticipantOperation with a new object
     *
     * @param newMuteParticipantOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MuteParticipantOperation> putAsync(@Nonnull final MuteParticipantOperation newMuteParticipantOperation) {
        return sendAsync(HttpMethod.PUT, newMuteParticipantOperation);
    }

    /**
     * Creates a MuteParticipantOperation with a new object
     *
     * @param newMuteParticipantOperation the object to create/update
     * @return the created MuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MuteParticipantOperation put(@Nonnull final MuteParticipantOperation newMuteParticipantOperation) throws ClientException {
        return send(HttpMethod.PUT, newMuteParticipantOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MuteParticipantOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MuteParticipantOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

