// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CrossTenantAccessPolicy;
import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.ExtensionProperty;
import com.microsoft.graph.requests.CrossTenantAccessPolicyConfigurationDefaultRequestBuilder;
import com.microsoft.graph.requests.CrossTenantAccessPolicyConfigurationPartnerCollectionRequestBuilder;
import com.microsoft.graph.requests.CrossTenantAccessPolicyConfigurationPartnerRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cross Tenant Access Policy Request.
 */
public class CrossTenantAccessPolicyRequest extends BaseRequest<CrossTenantAccessPolicy> {
	
    /**
     * The request for the CrossTenantAccessPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CrossTenantAccessPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CrossTenantAccessPolicy.class);
    }

    /**
     * Gets the CrossTenantAccessPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CrossTenantAccessPolicy from the service
     *
     * @return the CrossTenantAccessPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CrossTenantAccessPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CrossTenantAccessPolicy with a source
     *
     * @param sourceCrossTenantAccessPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicy> patchAsync(@Nonnull final CrossTenantAccessPolicy sourceCrossTenantAccessPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceCrossTenantAccessPolicy);
    }

    /**
     * Patches this CrossTenantAccessPolicy with a source
     *
     * @param sourceCrossTenantAccessPolicy the source object with updates
     * @return the updated CrossTenantAccessPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicy patch(@Nonnull final CrossTenantAccessPolicy sourceCrossTenantAccessPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceCrossTenantAccessPolicy);
    }

    /**
     * Creates a CrossTenantAccessPolicy with a new object
     *
     * @param newCrossTenantAccessPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicy> postAsync(@Nonnull final CrossTenantAccessPolicy newCrossTenantAccessPolicy) {
        return sendAsync(HttpMethod.POST, newCrossTenantAccessPolicy);
    }

    /**
     * Creates a CrossTenantAccessPolicy with a new object
     *
     * @param newCrossTenantAccessPolicy the new object to create
     * @return the created CrossTenantAccessPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicy post(@Nonnull final CrossTenantAccessPolicy newCrossTenantAccessPolicy) throws ClientException {
        return send(HttpMethod.POST, newCrossTenantAccessPolicy);
    }

    /**
     * Creates a CrossTenantAccessPolicy with a new object
     *
     * @param newCrossTenantAccessPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantAccessPolicy> putAsync(@Nonnull final CrossTenantAccessPolicy newCrossTenantAccessPolicy) {
        return sendAsync(HttpMethod.PUT, newCrossTenantAccessPolicy);
    }

    /**
     * Creates a CrossTenantAccessPolicy with a new object
     *
     * @param newCrossTenantAccessPolicy the object to create/update
     * @return the created CrossTenantAccessPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantAccessPolicy put(@Nonnull final CrossTenantAccessPolicy newCrossTenantAccessPolicy) throws ClientException {
        return send(HttpMethod.PUT, newCrossTenantAccessPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CrossTenantAccessPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CrossTenantAccessPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

