// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryCustodian;
import com.microsoft.graph.security.requests.EdiscoveryIndexOperationWithReferenceRequestBuilder;
import com.microsoft.graph.security.requests.SiteSourceCollectionRequestBuilder;
import com.microsoft.graph.security.requests.SiteSourceRequestBuilder;
import com.microsoft.graph.security.requests.UnifiedGroupSourceCollectionRequestBuilder;
import com.microsoft.graph.security.requests.UnifiedGroupSourceRequestBuilder;
import com.microsoft.graph.security.requests.UserSourceCollectionRequestBuilder;
import com.microsoft.graph.security.requests.UserSourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Custodian Request.
 */
public class EdiscoveryCustodianRequest extends BaseRequest<EdiscoveryCustodian> {
	
    /**
     * The request for the EdiscoveryCustodian
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCustodianRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryCustodian.class);
    }

    /**
     * Gets the EdiscoveryCustodian from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCustodian> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryCustodian from the service
     *
     * @return the EdiscoveryCustodian from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCustodian get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCustodian> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryCustodian delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryCustodian with a source
     *
     * @param sourceEdiscoveryCustodian the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCustodian> patchAsync(@Nonnull final EdiscoveryCustodian sourceEdiscoveryCustodian) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryCustodian);
    }

    /**
     * Patches this EdiscoveryCustodian with a source
     *
     * @param sourceEdiscoveryCustodian the source object with updates
     * @return the updated EdiscoveryCustodian
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCustodian patch(@Nonnull final EdiscoveryCustodian sourceEdiscoveryCustodian) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryCustodian);
    }

    /**
     * Creates a EdiscoveryCustodian with a new object
     *
     * @param newEdiscoveryCustodian the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCustodian> postAsync(@Nonnull final EdiscoveryCustodian newEdiscoveryCustodian) {
        return sendAsync(HttpMethod.POST, newEdiscoveryCustodian);
    }

    /**
     * Creates a EdiscoveryCustodian with a new object
     *
     * @param newEdiscoveryCustodian the new object to create
     * @return the created EdiscoveryCustodian
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCustodian post(@Nonnull final EdiscoveryCustodian newEdiscoveryCustodian) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryCustodian);
    }

    /**
     * Creates a EdiscoveryCustodian with a new object
     *
     * @param newEdiscoveryCustodian the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryCustodian> putAsync(@Nonnull final EdiscoveryCustodian newEdiscoveryCustodian) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryCustodian);
    }

    /**
     * Creates a EdiscoveryCustodian with a new object
     *
     * @param newEdiscoveryCustodian the object to create/update
     * @return the created EdiscoveryCustodian
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryCustodian put(@Nonnull final EdiscoveryCustodian newEdiscoveryCustodian) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryCustodian);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryCustodianRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryCustodianRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

