// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryReviewTag;
import com.microsoft.graph.security.requests.EdiscoveryReviewTagCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewTagWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Tag Request.
 */
public class EdiscoveryReviewTagRequest extends BaseRequest<EdiscoveryReviewTag> {
	
    /**
     * The request for the EdiscoveryReviewTag
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryReviewTagRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryReviewTag.class);
    }

    /**
     * Gets the EdiscoveryReviewTag from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewTag> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryReviewTag from the service
     *
     * @return the EdiscoveryReviewTag from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewTag get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewTag> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryReviewTag delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryReviewTag with a source
     *
     * @param sourceEdiscoveryReviewTag the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewTag> patchAsync(@Nonnull final EdiscoveryReviewTag sourceEdiscoveryReviewTag) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryReviewTag);
    }

    /**
     * Patches this EdiscoveryReviewTag with a source
     *
     * @param sourceEdiscoveryReviewTag the source object with updates
     * @return the updated EdiscoveryReviewTag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewTag patch(@Nonnull final EdiscoveryReviewTag sourceEdiscoveryReviewTag) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryReviewTag);
    }

    /**
     * Creates a EdiscoveryReviewTag with a new object
     *
     * @param newEdiscoveryReviewTag the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewTag> postAsync(@Nonnull final EdiscoveryReviewTag newEdiscoveryReviewTag) {
        return sendAsync(HttpMethod.POST, newEdiscoveryReviewTag);
    }

    /**
     * Creates a EdiscoveryReviewTag with a new object
     *
     * @param newEdiscoveryReviewTag the new object to create
     * @return the created EdiscoveryReviewTag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewTag post(@Nonnull final EdiscoveryReviewTag newEdiscoveryReviewTag) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryReviewTag);
    }

    /**
     * Creates a EdiscoveryReviewTag with a new object
     *
     * @param newEdiscoveryReviewTag the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryReviewTag> putAsync(@Nonnull final EdiscoveryReviewTag newEdiscoveryReviewTag) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryReviewTag);
    }

    /**
     * Creates a EdiscoveryReviewTag with a new object
     *
     * @param newEdiscoveryReviewTag the object to create/update
     * @return the created EdiscoveryReviewTag
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryReviewTag put(@Nonnull final EdiscoveryReviewTag newEdiscoveryReviewTag) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryReviewTag);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryReviewTagRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryReviewTagRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

