// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UnifiedRoleManagementPolicyRule;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Management Policy Expiration Rule.
 */
public class UnifiedRoleManagementPolicyExpirationRule extends UnifiedRoleManagementPolicyRule implements IJsonBackedObject {


    /**
     * The Is Expiration Required.
     * Indicates whether expiration is required or if it's a permanently active assignment or eligibility.
     */
    @SerializedName(value = "isExpirationRequired", alternate = {"IsExpirationRequired"})
    @Expose
	@Nullable
    public Boolean isExpirationRequired;

    /**
     * The Maximum Duration.
     * The maximum duration allowed for eligibility or assignment which is not permanent. Required when isExpirationRequired is true.
     */
    @SerializedName(value = "maximumDuration", alternate = {"MaximumDuration"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration maximumDuration;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
