// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Irr Parameter Set.
 */
public class WorkbookFunctionsIrrParameterSet {
    /**
     * The values.
     * 
     */
    @SerializedName(value = "values", alternate = {"Values"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement values;

    /**
     * The guess.
     * 
     */
    @SerializedName(value = "guess", alternate = {"Guess"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement guess;


    /**
     * Instiaciates a new WorkbookFunctionsIrrParameterSet
     */
    public WorkbookFunctionsIrrParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsIrrParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsIrrParameterSet(@Nonnull final WorkbookFunctionsIrrParameterSetBuilder builder) {
        this.values = builder.values;
        this.guess = builder.guess;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsIrrParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsIrrParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsIrrParameterSet
     */
    public static final class WorkbookFunctionsIrrParameterSetBuilder {
        /**
         * The values parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement values;
        /**
         * Sets the Values
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsIrrParameterSetBuilder withValues(@Nullable final com.google.gson.JsonElement val) {
            this.values = val;
            return this;
        }
        /**
         * The guess parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement guess;
        /**
         * Sets the Guess
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsIrrParameterSetBuilder withGuess(@Nullable final com.google.gson.JsonElement val) {
            this.guess = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsIrrParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsIrrParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsIrrParameterSet build() {
            return new WorkbookFunctionsIrrParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.values != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("values", values));
        }
        if(this.guess != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("guess", guess));
        }
        return result;
    }
}
