// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookRange;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Intersection Parameter Set.
 */
public class WorkbookRangeIntersectionParameterSet {
    /**
     * The another Range.
     * 
     */
    @SerializedName(value = "anotherRange", alternate = {"AnotherRange"})
    @Expose
	@Nullable
    public String anotherRange;


    /**
     * Instiaciates a new WorkbookRangeIntersectionParameterSet
     */
    public WorkbookRangeIntersectionParameterSet() {}
    /**
     * Instiaciates a new WorkbookRangeIntersectionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookRangeIntersectionParameterSet(@Nonnull final WorkbookRangeIntersectionParameterSetBuilder builder) {
        this.anotherRange = builder.anotherRange;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookRangeIntersectionParameterSetBuilder newBuilder() {
        return new WorkbookRangeIntersectionParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookRangeIntersectionParameterSet
     */
    public static final class WorkbookRangeIntersectionParameterSetBuilder {
        /**
         * The anotherRange parameter value
         */
        @Nullable
        protected String anotherRange;
        /**
         * Sets the AnotherRange
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeIntersectionParameterSetBuilder withAnotherRange(@Nullable final String val) {
            this.anotherRange = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookRangeIntersectionParameterSetBuilder
         */
        @Nullable
        protected WorkbookRangeIntersectionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookRangeIntersectionParameterSet build() {
            return new WorkbookRangeIntersectionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.anotherRange != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("anotherRange", anotherRange));
        }
        return result;
    }
}
