// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Approval;
import com.microsoft.graph.models.ApprovalFilterByCurrentUserOptions;
import com.microsoft.graph.requests.ApprovalStageCollectionRequestBuilder;
import com.microsoft.graph.requests.ApprovalStageRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Approval Request.
 */
public class ApprovalRequest extends BaseRequest<Approval> {
	
    /**
     * The request for the Approval
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ApprovalRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Approval.class);
    }

    /**
     * Gets the Approval from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Approval> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Approval from the service
     *
     * @return the Approval from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Approval get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Approval> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Approval delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Approval with a source
     *
     * @param sourceApproval the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Approval> patchAsync(@Nonnull final Approval sourceApproval) {
        return sendAsync(HttpMethod.PATCH, sourceApproval);
    }

    /**
     * Patches this Approval with a source
     *
     * @param sourceApproval the source object with updates
     * @return the updated Approval
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Approval patch(@Nonnull final Approval sourceApproval) throws ClientException {
        return send(HttpMethod.PATCH, sourceApproval);
    }

    /**
     * Creates a Approval with a new object
     *
     * @param newApproval the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Approval> postAsync(@Nonnull final Approval newApproval) {
        return sendAsync(HttpMethod.POST, newApproval);
    }

    /**
     * Creates a Approval with a new object
     *
     * @param newApproval the new object to create
     * @return the created Approval
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Approval post(@Nonnull final Approval newApproval) throws ClientException {
        return send(HttpMethod.POST, newApproval);
    }

    /**
     * Creates a Approval with a new object
     *
     * @param newApproval the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Approval> putAsync(@Nonnull final Approval newApproval) {
        return sendAsync(HttpMethod.PUT, newApproval);
    }

    /**
     * Creates a Approval with a new object
     *
     * @param newApproval the object to create/update
     * @return the created Approval
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Approval put(@Nonnull final Approval newApproval) throws ClientException {
        return send(HttpMethod.PUT, newApproval);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ApprovalRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ApprovalRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

