// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingBusiness;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.StaffAvailabilityItem;
import com.microsoft.graph.requests.BookingAppointmentCollectionRequestBuilder;
import com.microsoft.graph.requests.BookingAppointmentRequestBuilder;
import com.microsoft.graph.requests.BookingCustomerBaseCollectionRequestBuilder;
import com.microsoft.graph.requests.BookingCustomerBaseRequestBuilder;
import com.microsoft.graph.requests.BookingCustomQuestionCollectionRequestBuilder;
import com.microsoft.graph.requests.BookingCustomQuestionRequestBuilder;
import com.microsoft.graph.requests.BookingServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.BookingServiceRequestBuilder;
import com.microsoft.graph.requests.BookingStaffMemberBaseCollectionRequestBuilder;
import com.microsoft.graph.requests.BookingStaffMemberBaseRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Business Request.
 */
public class BookingBusinessRequest extends BaseRequest<BookingBusiness> {
	
    /**
     * The request for the BookingBusiness
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingBusinessRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingBusiness.class);
    }

    /**
     * Gets the BookingBusiness from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingBusiness> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BookingBusiness from the service
     *
     * @return the BookingBusiness from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingBusiness get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingBusiness> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BookingBusiness delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BookingBusiness with a source
     *
     * @param sourceBookingBusiness the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingBusiness> patchAsync(@Nonnull final BookingBusiness sourceBookingBusiness) {
        return sendAsync(HttpMethod.PATCH, sourceBookingBusiness);
    }

    /**
     * Patches this BookingBusiness with a source
     *
     * @param sourceBookingBusiness the source object with updates
     * @return the updated BookingBusiness
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingBusiness patch(@Nonnull final BookingBusiness sourceBookingBusiness) throws ClientException {
        return send(HttpMethod.PATCH, sourceBookingBusiness);
    }

    /**
     * Creates a BookingBusiness with a new object
     *
     * @param newBookingBusiness the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingBusiness> postAsync(@Nonnull final BookingBusiness newBookingBusiness) {
        return sendAsync(HttpMethod.POST, newBookingBusiness);
    }

    /**
     * Creates a BookingBusiness with a new object
     *
     * @param newBookingBusiness the new object to create
     * @return the created BookingBusiness
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingBusiness post(@Nonnull final BookingBusiness newBookingBusiness) throws ClientException {
        return send(HttpMethod.POST, newBookingBusiness);
    }

    /**
     * Creates a BookingBusiness with a new object
     *
     * @param newBookingBusiness the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingBusiness> putAsync(@Nonnull final BookingBusiness newBookingBusiness) {
        return sendAsync(HttpMethod.PUT, newBookingBusiness);
    }

    /**
     * Creates a BookingBusiness with a new object
     *
     * @param newBookingBusiness the object to create/update
     * @return the created BookingBusiness
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingBusiness put(@Nonnull final BookingBusiness newBookingBusiness) throws ClientException {
        return send(HttpMethod.PUT, newBookingBusiness);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BookingBusinessRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BookingBusinessRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

