// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.OrganizationalBrandingProperties;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Properties Request Builder.
 */
public class OrganizationalBrandingPropertiesRequestBuilder extends BaseRequestBuilder<OrganizationalBrandingProperties> {

    /**
     * The request builder for the OrganizationalBrandingProperties
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationalBrandingPropertiesRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the OrganizationalBrandingPropertiesRequest instance
     */
    @Nonnull
    public OrganizationalBrandingPropertiesRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the OrganizationalBrandingPropertiesRequest instance
     */
    @Nonnull
    public OrganizationalBrandingPropertiesRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.OrganizationalBrandingPropertiesRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for backgroundImage
     *
     * @return the OrganizationalBrandingPropertiesBackgroundImageStreamRequestBuilder instance
     */
    @Nonnull
    public OrganizationalBrandingPropertiesBackgroundImageStreamRequestBuilder backgroundImage() {
        return new OrganizationalBrandingPropertiesBackgroundImageStreamRequestBuilder(getRequestUrlWithAdditionalSegment("backgroundImage"), getClient(), null);
    }

    /**
     * Gets the request builder for bannerLogo
     *
     * @return the OrganizationalBrandingPropertiesBannerLogoStreamRequestBuilder instance
     */
    @Nonnull
    public OrganizationalBrandingPropertiesBannerLogoStreamRequestBuilder bannerLogo() {
        return new OrganizationalBrandingPropertiesBannerLogoStreamRequestBuilder(getRequestUrlWithAdditionalSegment("bannerLogo"), getClient(), null);
    }

    /**
     * Gets the request builder for squareLogo
     *
     * @return the OrganizationalBrandingPropertiesSquareLogoStreamRequestBuilder instance
     */
    @Nonnull
    public OrganizationalBrandingPropertiesSquareLogoStreamRequestBuilder squareLogo() {
        return new OrganizationalBrandingPropertiesSquareLogoStreamRequestBuilder(getRequestUrlWithAdditionalSegment("squareLogo"), getClient(), null);
    }
}
