// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.DataSourceScopes;
import com.microsoft.graph.security.models.DataSource;
import com.microsoft.graph.security.models.EdiscoveryAddToReviewSetOperation;
import com.microsoft.graph.security.models.EdiscoveryEstimateOperation;
import com.microsoft.graph.security.models.EdiscoveryNoncustodialDataSource;
import com.microsoft.graph.security.models.Search;
import com.microsoft.graph.security.requests.DataSourceCollectionPage;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Search.
 */
public class EdiscoverySearch extends Search implements IJsonBackedObject {


    /**
     * The Data Source Scopes.
     * When specified, the collection will span across a service for an entire workload. Possible values are: none, allTenantMailboxes, allTenantSites, allCaseCustodians, allCaseNoncustodialDataSources.
     */
    @SerializedName(value = "dataSourceScopes", alternate = {"DataSourceScopes"})
    @Expose
	@Nullable
    public EnumSet<DataSourceScopes> dataSourceScopes;

    /**
     * The Additional Sources.
     * Adds an additional source to the eDiscovery search.
     */
    @SerializedName(value = "additionalSources", alternate = {"AdditionalSources"})
    @Expose
	@Nullable
    public DataSourceCollectionPage additionalSources;

    /**
     * The Add To Review Set Operation.
     * Adds the results of the eDiscovery search to the specified reviewSet.
     */
    @SerializedName(value = "addToReviewSetOperation", alternate = {"AddToReviewSetOperation"})
    @Expose
	@Nullable
    public EdiscoveryAddToReviewSetOperation addToReviewSetOperation;

    /**
     * The Custodian Sources.
     * Custodian sources that are included in the eDiscovery search.
     */
	@Nullable
    public DataSourceCollectionPage custodianSources;

    /**
     * The Last Estimate Statistics Operation.
     * The last estimate operation associated with the eDiscovery search.
     */
    @SerializedName(value = "lastEstimateStatisticsOperation", alternate = {"LastEstimateStatisticsOperation"})
    @Expose
	@Nullable
    public EdiscoveryEstimateOperation lastEstimateStatisticsOperation;

    /**
     * The Noncustodial Sources.
     * noncustodialDataSource sources that are included in the eDiscovery search
     */
	@Nullable
    public EdiscoveryNoncustodialDataSourceCollectionPage noncustodialSources;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("additionalSources")) {
            additionalSources = serializer.deserializeObject(json.get("additionalSources"), DataSourceCollectionPage.class);
        }

        if (json.has("custodianSources")) {
            custodianSources = serializer.deserializeObject(json.get("custodianSources"), DataSourceCollectionPage.class);
        }

        if (json.has("noncustodialSources")) {
            noncustodialSources = serializer.deserializeObject(json.get("noncustodialSources"), EdiscoveryNoncustodialDataSourceCollectionPage.class);
        }
    }
}
