// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryCase;
import com.microsoft.graph.security.requests.EdiscoveryCustodianCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCustodianRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceRequestBuilder;
import com.microsoft.graph.security.requests.CaseOperationCollectionRequestBuilder;
import com.microsoft.graph.security.requests.CaseOperationRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoverySearchCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoverySearchRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryCaseSettingsRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewTagCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewTagRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Case Request Builder.
 */
public class EdiscoveryCaseRequestBuilder extends BaseRequestBuilder<EdiscoveryCase> {

    /**
     * The request builder for the EdiscoveryCase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCaseRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EdiscoveryCaseRequest instance
     */
    @Nonnull
    public EdiscoveryCaseRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the EdiscoveryCaseRequest instance
     */
    @Nonnull
    public EdiscoveryCaseRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.EdiscoveryCaseRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the EdiscoveryCustodian collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EdiscoveryCustodianCollectionRequestBuilder custodians() {
        return new EdiscoveryCustodianCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("custodians"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoveryCustodian item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EdiscoveryCustodianRequestBuilder custodians(@Nonnull final String id) {
        return new EdiscoveryCustodianRequestBuilder(getRequestUrlWithAdditionalSegment("custodians") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the EdiscoveryNoncustodialDataSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EdiscoveryNoncustodialDataSourceCollectionRequestBuilder noncustodialDataSources() {
        return new EdiscoveryNoncustodialDataSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("noncustodialDataSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoveryNoncustodialDataSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EdiscoveryNoncustodialDataSourceRequestBuilder noncustodialDataSources(@Nonnull final String id) {
        return new EdiscoveryNoncustodialDataSourceRequestBuilder(getRequestUrlWithAdditionalSegment("noncustodialDataSources") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the CaseOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public CaseOperationCollectionRequestBuilder operations() {
        return new CaseOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the CaseOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public CaseOperationRequestBuilder operations(@Nonnull final String id) {
        return new CaseOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the EdiscoveryReviewSet collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EdiscoveryReviewSetCollectionRequestBuilder reviewSets() {
        return new EdiscoveryReviewSetCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("reviewSets"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoveryReviewSet item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EdiscoveryReviewSetRequestBuilder reviewSets(@Nonnull final String id) {
        return new EdiscoveryReviewSetRequestBuilder(getRequestUrlWithAdditionalSegment("reviewSets") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the EdiscoverySearch collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EdiscoverySearchCollectionRequestBuilder searches() {
        return new EdiscoverySearchCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("searches"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoverySearch item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EdiscoverySearchRequestBuilder searches(@Nonnull final String id) {
        return new EdiscoverySearchRequestBuilder(getRequestUrlWithAdditionalSegment("searches") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for EdiscoveryCaseSettings
     *
     * @return the EdiscoveryCaseSettingsRequestBuilder instance
     */
    @Nonnull
    public EdiscoveryCaseSettingsRequestBuilder settings() {
        return new EdiscoveryCaseSettingsRequestBuilder(getRequestUrlWithAdditionalSegment("settings"), getClient(), null);
    }
    /**
     *  Gets a request builder for the EdiscoveryReviewTag collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EdiscoveryReviewTagCollectionRequestBuilder tags() {
        return new EdiscoveryReviewTagCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("tags"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoveryReviewTag item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EdiscoveryReviewTagRequestBuilder tags(@Nonnull final String id) {
        return new EdiscoveryReviewTagRequestBuilder(getRequestUrlWithAdditionalSegment("tags") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EdiscoveryCaseCloseRequestBuilder close() {
        return new EdiscoveryCaseCloseRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.close"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EdiscoveryCaseReopenRequestBuilder reopen() {
        return new EdiscoveryCaseReopenRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.reopen"), getClient(), null);
    }
}
