// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryReviewSet;
import com.microsoft.graph.security.models.EdiscoverySearch;
import com.microsoft.graph.security.models.AdditionalDataOptions;
import java.util.EnumSet;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryCollectionRequestBuilder;
import com.microsoft.graph.security.requests.EdiscoveryReviewSetQueryRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.security.models.EdiscoveryReviewSetAddToReviewSetParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Review Set Request Builder.
 */
public class EdiscoveryReviewSetRequestBuilder extends BaseRequestBuilder<EdiscoveryReviewSet> {

    /**
     * The request builder for the EdiscoveryReviewSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryReviewSetRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EdiscoveryReviewSetRequest instance
     */
    @Nonnull
    public EdiscoveryReviewSetRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the EdiscoveryReviewSetRequest instance
     */
    @Nonnull
    public EdiscoveryReviewSetRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.EdiscoveryReviewSetRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the EdiscoveryReviewSetQuery collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EdiscoveryReviewSetQueryCollectionRequestBuilder queries() {
        return new EdiscoveryReviewSetQueryCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("queries"), getClient(), null);
    }

    /**
     * Gets a request builder for the EdiscoveryReviewSetQuery item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EdiscoveryReviewSetQueryRequestBuilder queries(@Nonnull final String id) {
        return new EdiscoveryReviewSetQueryRequestBuilder(getRequestUrlWithAdditionalSegment("queries") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public EdiscoveryReviewSetAddToReviewSetRequestBuilder addToReviewSet(@Nonnull final EdiscoveryReviewSetAddToReviewSetParameterSet parameters) {
        return new EdiscoveryReviewSetAddToReviewSetRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.security.addToReviewSet"), getClient(), null, parameters);
    }
}
