// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.NamedLocationCollectionPage;
import com.microsoft.graph.requests.ConditionalAccessPolicyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Root.
 */
public class ConditionalAccessRoot extends Entity implements IJsonBackedObject {


    /**
     * The Named Locations.
     * Read-only. Nullable. Returns a collection of the specified named locations.
     */
    @SerializedName(value = "namedLocations", alternate = {"NamedLocations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.NamedLocationCollectionPage namedLocations;

    /**
     * The Policies.
     * Read-only. Nullable. Returns a collection of the specified Conditional Access (CA) policies.
     */
    @SerializedName(value = "policies", alternate = {"Policies"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.ConditionalAccessPolicyCollectionPage policies;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("namedLocations")) {
            namedLocations = serializer.deserializeObject(json.get("namedLocations"), com.microsoft.graph.requests.NamedLocationCollectionPage.class);
        }

        if (json.has("policies")) {
            policies = serializer.deserializeObject(json.get("policies"), com.microsoft.graph.requests.ConditionalAccessPolicyCollectionPage.class);
        }
    }
}
