// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.NotebookGetNotebookFromWebUrlRequest;
import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.CopyNotebookModel;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.NotebookGetNotebookFromWebUrlParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Notebook Get Notebook From Web Url Request Builder.
 */
public class NotebookGetNotebookFromWebUrlRequestBuilder extends BaseActionRequestBuilder<CopyNotebookModel> {

    /**
     * The request builder for this NotebookGetNotebookFromWebUrl
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public NotebookGetNotebookFromWebUrlRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private NotebookGetNotebookFromWebUrlParameterSet body;
    /**
     * The request builder for this NotebookGetNotebookFromWebUrl
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public NotebookGetNotebookFromWebUrlRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final NotebookGetNotebookFromWebUrlParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the NotebookGetNotebookFromWebUrlRequest
     *
     * @param requestOptions the options for the request
     * @return the NotebookGetNotebookFromWebUrlRequest instance
     */
    @Nonnull
    public NotebookGetNotebookFromWebUrlRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the NotebookGetNotebookFromWebUrlRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the NotebookGetNotebookFromWebUrlRequest instance
     */
    @Nonnull
    public NotebookGetNotebookFromWebUrlRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final NotebookGetNotebookFromWebUrlRequest request = new NotebookGetNotebookFromWebUrlRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
