// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SearchEntity;
import com.microsoft.graph.models.SearchRequest;
import com.microsoft.graph.models.SearchResponse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Search Entity Request.
 */
public class SearchEntityRequest extends BaseRequest<SearchEntity> {
	
    /**
     * The request for the SearchEntity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SearchEntityRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SearchEntity.class);
    }

    /**
     * Gets the SearchEntity from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SearchEntity> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SearchEntity from the service
     *
     * @return the SearchEntity from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SearchEntity get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SearchEntity> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SearchEntity delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SearchEntity with a source
     *
     * @param sourceSearchEntity the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SearchEntity> patchAsync(@Nonnull final SearchEntity sourceSearchEntity) {
        return sendAsync(HttpMethod.PATCH, sourceSearchEntity);
    }

    /**
     * Patches this SearchEntity with a source
     *
     * @param sourceSearchEntity the source object with updates
     * @return the updated SearchEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SearchEntity patch(@Nonnull final SearchEntity sourceSearchEntity) throws ClientException {
        return send(HttpMethod.PATCH, sourceSearchEntity);
    }

    /**
     * Creates a SearchEntity with a new object
     *
     * @param newSearchEntity the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SearchEntity> postAsync(@Nonnull final SearchEntity newSearchEntity) {
        return sendAsync(HttpMethod.POST, newSearchEntity);
    }

    /**
     * Creates a SearchEntity with a new object
     *
     * @param newSearchEntity the new object to create
     * @return the created SearchEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SearchEntity post(@Nonnull final SearchEntity newSearchEntity) throws ClientException {
        return send(HttpMethod.POST, newSearchEntity);
    }

    /**
     * Creates a SearchEntity with a new object
     *
     * @param newSearchEntity the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SearchEntity> putAsync(@Nonnull final SearchEntity newSearchEntity) {
        return sendAsync(HttpMethod.PUT, newSearchEntity);
    }

    /**
     * Creates a SearchEntity with a new object
     *
     * @param newSearchEntity the object to create/update
     * @return the created SearchEntity
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SearchEntity put(@Nonnull final SearchEntity newSearchEntity) throws ClientException {
        return send(HttpMethod.PUT, newSearchEntity);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SearchEntityRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SearchEntityRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

