// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Team;
import com.microsoft.graph.models.TeamVisibilityType;
import com.microsoft.graph.models.ClonableTeamParts;
import java.util.EnumSet;
import com.microsoft.graph.models.TeamworkActivityTopic;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.TeamworkNotificationRecipient;
import com.microsoft.graph.models.ChatMessage;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.TeamArchiveParameterSet;
import com.microsoft.graph.models.TeamCloneParameterSet;
import com.microsoft.graph.models.TeamSendActivityNotificationParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Team Request Builder.
 */
public class TeamRequestBuilder extends BaseRequestBuilder<Team> {

    /**
     * The request builder for the Team
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TeamRequest instance
     */
    @Nonnull
    public TeamRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the TeamRequest instance
     */
    @Nonnull
    public TeamRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.TeamRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Channel collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelCollectionWithReferencesRequestBuilder allChannels() {
        return new com.microsoft.graph.requests.ChannelCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("allChannels"), getClient(), null);
    }

    /**
     * Gets a request builder for the Channel item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelWithReferenceRequestBuilder allChannels(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChannelWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("allChannels") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Channel collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelCollectionRequestBuilder channels() {
        return new com.microsoft.graph.requests.ChannelCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("channels"), getClient(), null);
    }

    /**
     * Gets a request builder for the Channel item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelRequestBuilder channels(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChannelRequestBuilder(getRequestUrlWithAdditionalSegment("channels") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for Group
     *
     * @return the GroupWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.GroupWithReferenceRequestBuilder group() {
        return new com.microsoft.graph.requests.GroupWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("group"), getClient(), null);
    }
    /**
     *  Gets a request builder for the Channel collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelCollectionWithReferencesRequestBuilder incomingChannels() {
        return new com.microsoft.graph.requests.ChannelCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("incomingChannels"), getClient(), null);
    }

    /**
     * Gets a request builder for the Channel item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelWithReferenceRequestBuilder incomingChannels(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ChannelWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("incomingChannels") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TeamsAppInstallation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder installedApps() {
        return new com.microsoft.graph.requests.TeamsAppInstallationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("installedApps"), getClient(), null);
    }

    /**
     * Gets a request builder for the TeamsAppInstallation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder installedApps(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TeamsAppInstallationRequestBuilder(getRequestUrlWithAdditionalSegment("installedApps") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the ConversationMember collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder members() {
        return new com.microsoft.graph.requests.ConversationMemberCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("members"), getClient(), null);
    }

    /**
     * Gets a request builder for the ConversationMember item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.ConversationMemberRequestBuilder members(@Nonnull final String id) {
        return new com.microsoft.graph.requests.ConversationMemberRequestBuilder(getRequestUrlWithAdditionalSegment("members") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the TeamsAsyncOperation collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAsyncOperationCollectionRequestBuilder operations() {
        return new com.microsoft.graph.requests.TeamsAsyncOperationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("operations"), getClient(), null);
    }

    /**
     * Gets a request builder for the TeamsAsyncOperation item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsAsyncOperationRequestBuilder operations(@Nonnull final String id) {
        return new com.microsoft.graph.requests.TeamsAsyncOperationRequestBuilder(getRequestUrlWithAdditionalSegment("operations") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for ProfilePhoto
     *
     * @return the ProfilePhotoRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.ProfilePhotoRequestBuilder photo() {
        return new com.microsoft.graph.requests.ProfilePhotoRequestBuilder(getRequestUrlWithAdditionalSegment("photo"), getClient(), null);
    }

    /**
     * Gets the request builder for Channel
     *
     * @return the ChannelRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.ChannelRequestBuilder primaryChannel() {
        return new com.microsoft.graph.requests.ChannelRequestBuilder(getRequestUrlWithAdditionalSegment("primaryChannel"), getClient(), null);
    }

    /**
     * Gets the request builder for TeamsTemplate
     *
     * @return the TeamsTemplateWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.TeamsTemplateWithReferenceRequestBuilder template() {
        return new com.microsoft.graph.requests.TeamsTemplateWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("template"), getClient(), null);
    }

    /**
     * Gets the request builder for Schedule
     *
     * @return the ScheduleRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.ScheduleRequestBuilder schedule() {
        return new com.microsoft.graph.requests.ScheduleRequestBuilder(getRequestUrlWithAdditionalSegment("schedule"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public TeamArchiveRequestBuilder archive(@Nonnull final TeamArchiveParameterSet parameters) {
        return new TeamArchiveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.archive"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public TeamUnarchiveRequestBuilder unarchive() {
        return new TeamUnarchiveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unarchive"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public TeamCloneRequestBuilder clone(@Nonnull final TeamCloneParameterSet parameters) {
        return new TeamCloneRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.clone"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public TeamCompleteMigrationRequestBuilder completeMigration() {
        return new TeamCompleteMigrationRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.completeMigration"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public TeamSendActivityNotificationRequestBuilder sendActivityNotification(@Nonnull final TeamSendActivityNotificationParameterSet parameters) {
        return new TeamSendActivityNotificationRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.sendActivityNotification"), getClient(), null, parameters);
    }
}
