// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UserIdentity;
import com.microsoft.graph.models.Identity;
import com.microsoft.graph.models.AccessReviewInstanceDecisionItemResource;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Instance Decision Item.
 */
public class AccessReviewInstanceDecisionItem extends Entity implements IJsonBackedObject {


    /**
     * The Access Review Id.
     * The identifier of the accessReviewInstance parent. Supports $select. Read-only.
     */
    @SerializedName(value = "accessReviewId", alternate = {"AccessReviewId"})
    @Expose
	@Nullable
    public String accessReviewId;

    /**
     * The Applied By.
     * The identifier of the user who applied the decision. Read-only.
     */
    @SerializedName(value = "appliedBy", alternate = {"AppliedBy"})
    @Expose
	@Nullable
    public UserIdentity appliedBy;

    /**
     * The Applied Date Time.
     * The timestamp when the approval decision was applied.00000000-0000-0000-0000-000000000000 if the assigned reviewer hasn't applied the decision or it was automatically applied. The DatetimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.  Supports $select. Read-only.
     */
    @SerializedName(value = "appliedDateTime", alternate = {"AppliedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime appliedDateTime;

    /**
     * The Apply Result.
     * The result of applying the decision. Possible values: New, AppliedSuccessfully, AppliedWithUnknownFailure, AppliedSuccessfullyButObjectNotFound and ApplyNotSupported. Supports $select, $orderby, and $filter (eq only). Read-only.
     */
    @SerializedName(value = "applyResult", alternate = {"ApplyResult"})
    @Expose
	@Nullable
    public String applyResult;

    /**
     * The Decision.
     * Result of the review. Possible values: Approve, Deny, NotReviewed, or DontKnow. Supports $select, $orderby, and $filter (eq only).
     */
    @SerializedName(value = "decision", alternate = {"Decision"})
    @Expose
	@Nullable
    public String decision;

    /**
     * The Justification.
     * Justification left by the reviewer when they made the decision.
     */
    @SerializedName(value = "justification", alternate = {"Justification"})
    @Expose
	@Nullable
    public String justification;

    /**
     * The Principal.
     * Every decision item in an access review represents a principal's access to a resource. This property represents details of the principal. For example, if a decision item represents access of User 'Bob' to Group 'Sales' - The principal is 'Bob' and the resource is 'Sales'. Principals can be of two types - userIdentity and servicePrincipalIdentity. Supports $select. Read-only.
     */
    @SerializedName(value = "principal", alternate = {"Principal"})
    @Expose
	@Nullable
    public Identity principal;

    /**
     * The Principal Link.
     * A link to the principal object. For example, https://graph.microsoft.com/v1.0/users/a6c7aecb-cbfd-4763-87ef-e91b4bd509d9. Read-only.
     */
    @SerializedName(value = "principalLink", alternate = {"PrincipalLink"})
    @Expose
	@Nullable
    public String principalLink;

    /**
     * The Recommendation.
     * A system-generated recommendation for the approval decision based off last interactive sign-in to tenant. Recommend approve if sign-in is within thirty days of start of review. Recommend deny if sign-in is greater than thirty days of start of review. Recommendation not available otherwise. Possible values: Approve, Deny, or NoInfoAvailable. Supports $select, $orderby, and $filter (eq only). Read-only.
     */
    @SerializedName(value = "recommendation", alternate = {"Recommendation"})
    @Expose
	@Nullable
    public String recommendation;

    /**
     * The Resource.
     * Every decision item in an access review represents a principal's access to a resource. This property represents details of the resource. For example, if a decision item represents access of User 'Bob' to Group 'Sales' - The principal is Bob and the resource is 'Sales'. Resources can be of multiple types. See accessReviewInstanceDecisionItemResource. Read-only.
     */
    @SerializedName(value = "resource", alternate = {"Resource"})
    @Expose
	@Nullable
    public AccessReviewInstanceDecisionItemResource resource;

    /**
     * The Resource Link.
     * A link to the resource. For example, https://graph.microsoft.com/v1.0/servicePrincipals/c86300f3-8695-4320-9f6e-32a2555f5ff8. Supports $select. Read-only.
     */
    @SerializedName(value = "resourceLink", alternate = {"ResourceLink"})
    @Expose
	@Nullable
    public String resourceLink;

    /**
     * The Reviewed By.
     * The identifier of the reviewer.00000000-0000-0000-0000-000000000000 if the assigned reviewer hasn't reviewed. Supports $select. Read-only.
     */
    @SerializedName(value = "reviewedBy", alternate = {"ReviewedBy"})
    @Expose
	@Nullable
    public UserIdentity reviewedBy;

    /**
     * The Reviewed Date Time.
     * The timestamp when the review decision occurred. Supports $select. Read-only.
     */
    @SerializedName(value = "reviewedDateTime", alternate = {"ReviewedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime reviewedDateTime;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
