// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DeviceManagementReportFileFormat;
import com.microsoft.graph.models.DeviceManagementExportJobLocalizationType;
import com.microsoft.graph.models.DeviceManagementReportStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Export Job.
 */
public class DeviceManagementExportJob extends Entity implements IJsonBackedObject {


    /**
     * The Expiration Date Time.
     * Time that the exported report expires
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The Filter.
     * Filters applied on the report
     */
    @SerializedName(value = "filter", alternate = {"Filter"})
    @Expose
	@Nullable
    public String filter;

    /**
     * The Format.
     * Format of the exported report. Possible values are: csv, json.
     */
    @SerializedName(value = "format", alternate = {"Format"})
    @Expose
	@Nullable
    public DeviceManagementReportFileFormat format;

    /**
     * The Localization Type.
     * Configures how the requested export job is localized. Possible values are: localizedValuesAsAdditionalColumn, replaceLocalizableValues.
     */
    @SerializedName(value = "localizationType", alternate = {"LocalizationType"})
    @Expose
	@Nullable
    public DeviceManagementExportJobLocalizationType localizationType;

    /**
     * The Report Name.
     * Name of the report
     */
    @SerializedName(value = "reportName", alternate = {"ReportName"})
    @Expose
	@Nullable
    public String reportName;

    /**
     * The Request Date Time.
     * Time that the exported report was requested
     */
    @SerializedName(value = "requestDateTime", alternate = {"RequestDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime requestDateTime;

    /**
     * The Select.
     * Columns selected from the report
     */
    @SerializedName(value = "select", alternate = {"Select"})
    @Expose
	@Nullable
    public java.util.List<String> select;

    /**
     * The Snapshot Id.
     * A snapshot is an identifiable subset of the dataset represented by the ReportName. A sessionId or CachedReportConfiguration id can be used here. If a sessionId is specified, Filter, Select, and OrderBy are applied to the data represented by the sessionId. Filter, Select, and OrderBy cannot be specified together with a CachedReportConfiguration id.
     */
    @SerializedName(value = "snapshotId", alternate = {"SnapshotId"})
    @Expose
	@Nullable
    public String snapshotId;

    /**
     * The Status.
     * Status of the export job. Possible values are: unknown, notStarted, inProgress, completed, failed.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public DeviceManagementReportStatus status;

    /**
     * The Url.
     * Temporary location of the exported report
     */
    @SerializedName(value = "url", alternate = {"Url"})
    @Expose
	@Nullable
    public String url;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
