// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SectionLinks;
import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.SectionGroup;
import com.microsoft.graph.models.OnenoteEntityHierarchyModel;
import com.microsoft.graph.requests.OnenotePageCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Section.
 */
public class OnenoteSection extends OnenoteEntityHierarchyModel implements IJsonBackedObject {


    /**
     * The Is Default.
     * Indicates whether this is the user's default section. Read-only.
     */
    @SerializedName(value = "isDefault", alternate = {"IsDefault"})
    @Expose
	@Nullable
    public Boolean isDefault;

    /**
     * The Links.
     * Links for opening the section. The oneNoteClientURL link opens the section in the OneNote native client if it's installed. The oneNoteWebURL link opens the section in OneNote on the web.
     */
    @SerializedName(value = "links", alternate = {"Links"})
    @Expose
	@Nullable
    public SectionLinks links;

    /**
     * The Pages Url.
     * The pages endpoint where you can get details for all the pages in the section. Read-only.
     */
    @SerializedName(value = "pagesUrl", alternate = {"PagesUrl"})
    @Expose
	@Nullable
    public String pagesUrl;

    /**
     * The Pages.
     * The collection of pages in the section.  Read-only. Nullable.
     */
    @SerializedName(value = "pages", alternate = {"Pages"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.OnenotePageCollectionPage pages;

    /**
     * The Parent Notebook.
     * The notebook that contains the section.  Read-only.
     */
    @SerializedName(value = "parentNotebook", alternate = {"ParentNotebook"})
    @Expose
	@Nullable
    public Notebook parentNotebook;

    /**
     * The Parent Section Group.
     * The section group that contains the section.  Read-only.
     */
    @SerializedName(value = "parentSectionGroup", alternate = {"ParentSectionGroup"})
    @Expose
	@Nullable
    public SectionGroup parentSectionGroup;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("pages")) {
            pages = serializer.deserializeObject(json.get("pages"), com.microsoft.graph.requests.OnenotePageCollectionPage.class);
        }
    }
}
