// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Teamwork;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Request.
 */
public class TeamworkRequest extends BaseRequest<Teamwork> {
	
    /**
     * The request for the Teamwork
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamworkRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Teamwork.class);
    }

    /**
     * Gets the Teamwork from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Teamwork> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Teamwork from the service
     *
     * @return the Teamwork from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Teamwork get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Teamwork> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Teamwork delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Teamwork with a source
     *
     * @param sourceTeamwork the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Teamwork> patchAsync(@Nonnull final Teamwork sourceTeamwork) {
        return sendAsync(HttpMethod.PATCH, sourceTeamwork);
    }

    /**
     * Patches this Teamwork with a source
     *
     * @param sourceTeamwork the source object with updates
     * @return the updated Teamwork
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Teamwork patch(@Nonnull final Teamwork sourceTeamwork) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamwork);
    }

    /**
     * Creates a Teamwork with a new object
     *
     * @param newTeamwork the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Teamwork> postAsync(@Nonnull final Teamwork newTeamwork) {
        return sendAsync(HttpMethod.POST, newTeamwork);
    }

    /**
     * Creates a Teamwork with a new object
     *
     * @param newTeamwork the new object to create
     * @return the created Teamwork
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Teamwork post(@Nonnull final Teamwork newTeamwork) throws ClientException {
        return send(HttpMethod.POST, newTeamwork);
    }

    /**
     * Creates a Teamwork with a new object
     *
     * @param newTeamwork the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Teamwork> putAsync(@Nonnull final Teamwork newTeamwork) {
        return sendAsync(HttpMethod.PUT, newTeamwork);
    }

    /**
     * Creates a Teamwork with a new object
     *
     * @param newTeamwork the object to create/update
     * @return the created Teamwork
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Teamwork put(@Nonnull final Teamwork newTeamwork) throws ClientException {
        return send(HttpMethod.PUT, newTeamwork);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

