// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookChartGridlines;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Gridlines Request.
 */
public class WorkbookChartGridlinesRequest extends BaseRequest<WorkbookChartGridlines> {
	
    /**
     * The request for the WorkbookChartGridlines
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartGridlinesRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartGridlines.class);
    }

    /**
     * Gets the WorkbookChartGridlines from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartGridlines> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the WorkbookChartGridlines from the service
     *
     * @return the WorkbookChartGridlines from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartGridlines get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartGridlines> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public WorkbookChartGridlines delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookChartGridlines with a source
     *
     * @param sourceWorkbookChartGridlines the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartGridlines> patchAsync(@Nonnull final WorkbookChartGridlines sourceWorkbookChartGridlines) {
        return sendAsync(HttpMethod.PATCH, sourceWorkbookChartGridlines);
    }

    /**
     * Patches this WorkbookChartGridlines with a source
     *
     * @param sourceWorkbookChartGridlines the source object with updates
     * @return the updated WorkbookChartGridlines
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartGridlines patch(@Nonnull final WorkbookChartGridlines sourceWorkbookChartGridlines) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartGridlines);
    }

    /**
     * Creates a WorkbookChartGridlines with a new object
     *
     * @param newWorkbookChartGridlines the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartGridlines> postAsync(@Nonnull final WorkbookChartGridlines newWorkbookChartGridlines) {
        return sendAsync(HttpMethod.POST, newWorkbookChartGridlines);
    }

    /**
     * Creates a WorkbookChartGridlines with a new object
     *
     * @param newWorkbookChartGridlines the new object to create
     * @return the created WorkbookChartGridlines
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartGridlines post(@Nonnull final WorkbookChartGridlines newWorkbookChartGridlines) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartGridlines);
    }

    /**
     * Creates a WorkbookChartGridlines with a new object
     *
     * @param newWorkbookChartGridlines the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<WorkbookChartGridlines> putAsync(@Nonnull final WorkbookChartGridlines newWorkbookChartGridlines) {
        return sendAsync(HttpMethod.PUT, newWorkbookChartGridlines);
    }

    /**
     * Creates a WorkbookChartGridlines with a new object
     *
     * @param newWorkbookChartGridlines the object to create/update
     * @return the created WorkbookChartGridlines
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public WorkbookChartGridlines put(@Nonnull final WorkbookChartGridlines newWorkbookChartGridlines) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookChartGridlines);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartGridlinesRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public WorkbookChartGridlinesRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

