// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.termstore.models.Relation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Relation Request.
 */
public class RelationRequest extends BaseRequest<Relation> {
	
    /**
     * The request for the Relation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RelationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Relation.class);
    }

    /**
     * Gets the Relation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Relation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Relation from the service
     *
     * @return the Relation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Relation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Relation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Relation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Relation with a source
     *
     * @param sourceRelation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Relation> patchAsync(@Nonnull final Relation sourceRelation) {
        return sendAsync(HttpMethod.PATCH, sourceRelation);
    }

    /**
     * Patches this Relation with a source
     *
     * @param sourceRelation the source object with updates
     * @return the updated Relation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Relation patch(@Nonnull final Relation sourceRelation) throws ClientException {
        return send(HttpMethod.PATCH, sourceRelation);
    }

    /**
     * Creates a Relation with a new object
     *
     * @param newRelation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Relation> postAsync(@Nonnull final Relation newRelation) {
        return sendAsync(HttpMethod.POST, newRelation);
    }

    /**
     * Creates a Relation with a new object
     *
     * @param newRelation the new object to create
     * @return the created Relation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Relation post(@Nonnull final Relation newRelation) throws ClientException {
        return send(HttpMethod.POST, newRelation);
    }

    /**
     * Creates a Relation with a new object
     *
     * @param newRelation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Relation> putAsync(@Nonnull final Relation newRelation) {
        return sendAsync(HttpMethod.PUT, newRelation);
    }

    /**
     * Creates a Relation with a new object
     *
     * @param newRelation the object to create/update
     * @return the created Relation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Relation put(@Nonnull final Relation newRelation) throws ClientException {
        return send(HttpMethod.PUT, newRelation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RelationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RelationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

