// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentityProviderBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Social Identity Provider.
 */
public class SocialIdentityProvider extends IdentityProviderBase implements IJsonBackedObject {


    /**
     * The Client Id.
     * The identifier for the client application obtained when registering the application with the identity provider. Required.
     */
    @SerializedName(value = "clientId", alternate = {"ClientId"})
    @Expose
	@Nullable
    public String clientId;

    /**
     * The Client Secret.
     * The client secret for the application that is obtained when the application is registered with the identity provider. This is write-only. A read operation returns ****. Required.
     */
    @SerializedName(value = "clientSecret", alternate = {"ClientSecret"})
    @Expose
	@Nullable
    public String clientSecret;

    /**
     * The Identity Provider Type.
     * For a B2B scenario, possible values: Google, Facebook. For a B2C scenario, possible values: Microsoft, Google, Amazon, LinkedIn, Facebook, GitHub, Twitter, Weibo, QQ, WeChat. Required.
     */
    @SerializedName(value = "identityProviderType", alternate = {"IdentityProviderType"})
    @Expose
	@Nullable
    public String identityProviderType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
