// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.X509CertificateAuthenticationModeConfiguration;
import com.microsoft.graph.models.X509CertificateUserBinding;
import com.microsoft.graph.models.AuthenticationMethodConfiguration;
import com.microsoft.graph.requests.AuthenticationMethodTargetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the X509Certificate Authentication Method Configuration.
 */
public class X509CertificateAuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements IJsonBackedObject {


    /**
     * The Authentication Mode Configuration.
     * 
     */
    @SerializedName(value = "authenticationModeConfiguration", alternate = {"AuthenticationModeConfiguration"})
    @Expose
	@Nullable
    public X509CertificateAuthenticationModeConfiguration authenticationModeConfiguration;

    /**
     * The Certificate User Bindings.
     * 
     */
    @SerializedName(value = "certificateUserBindings", alternate = {"CertificateUserBindings"})
    @Expose
	@Nullable
    public java.util.List<X509CertificateUserBinding> certificateUserBindings;

    /**
     * The Include Targets.
     * 
     */
    @SerializedName(value = "includeTargets", alternate = {"IncludeTargets"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AuthenticationMethodTargetCollectionPage includeTargets;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("includeTargets")) {
            includeTargets = serializer.deserializeObject(json.get("includeTargets"), com.microsoft.graph.requests.AuthenticationMethodTargetCollectionPage.class);
        }
    }
}
