// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CancelMediaProcessingOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cancel Media Processing Operation Request.
 */
public class CancelMediaProcessingOperationRequest extends BaseRequest<CancelMediaProcessingOperation> {
	
    /**
     * The request for the CancelMediaProcessingOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CancelMediaProcessingOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CancelMediaProcessingOperation.class);
    }

    /**
     * Gets the CancelMediaProcessingOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CancelMediaProcessingOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CancelMediaProcessingOperation from the service
     *
     * @return the CancelMediaProcessingOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CancelMediaProcessingOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CancelMediaProcessingOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CancelMediaProcessingOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CancelMediaProcessingOperation with a source
     *
     * @param sourceCancelMediaProcessingOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CancelMediaProcessingOperation> patchAsync(@Nonnull final CancelMediaProcessingOperation sourceCancelMediaProcessingOperation) {
        return sendAsync(HttpMethod.PATCH, sourceCancelMediaProcessingOperation);
    }

    /**
     * Patches this CancelMediaProcessingOperation with a source
     *
     * @param sourceCancelMediaProcessingOperation the source object with updates
     * @return the updated CancelMediaProcessingOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CancelMediaProcessingOperation patch(@Nonnull final CancelMediaProcessingOperation sourceCancelMediaProcessingOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceCancelMediaProcessingOperation);
    }

    /**
     * Creates a CancelMediaProcessingOperation with a new object
     *
     * @param newCancelMediaProcessingOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CancelMediaProcessingOperation> postAsync(@Nonnull final CancelMediaProcessingOperation newCancelMediaProcessingOperation) {
        return sendAsync(HttpMethod.POST, newCancelMediaProcessingOperation);
    }

    /**
     * Creates a CancelMediaProcessingOperation with a new object
     *
     * @param newCancelMediaProcessingOperation the new object to create
     * @return the created CancelMediaProcessingOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CancelMediaProcessingOperation post(@Nonnull final CancelMediaProcessingOperation newCancelMediaProcessingOperation) throws ClientException {
        return send(HttpMethod.POST, newCancelMediaProcessingOperation);
    }

    /**
     * Creates a CancelMediaProcessingOperation with a new object
     *
     * @param newCancelMediaProcessingOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CancelMediaProcessingOperation> putAsync(@Nonnull final CancelMediaProcessingOperation newCancelMediaProcessingOperation) {
        return sendAsync(HttpMethod.PUT, newCancelMediaProcessingOperation);
    }

    /**
     * Creates a CancelMediaProcessingOperation with a new object
     *
     * @param newCancelMediaProcessingOperation the object to create/update
     * @return the created CancelMediaProcessingOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CancelMediaProcessingOperation put(@Nonnull final CancelMediaProcessingOperation newCancelMediaProcessingOperation) throws ClientException {
        return send(HttpMethod.PUT, newCancelMediaProcessingOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CancelMediaProcessingOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CancelMediaProcessingOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

