// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DriveItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.requests.DriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveSearchCollectionPage;
import com.microsoft.graph.requests.DriveSearchCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Search Collection Page.
 */
public class DriveSearchCollectionPage extends BaseCollectionPage<DriveItem, DriveSearchCollectionRequestBuilder> {

    /**
     * A collection page for DriveItem.
     *
     * @param response The serialized DriveSearchCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public DriveSearchCollectionPage(@Nonnull final DriveSearchCollectionResponse response, @Nonnull final DriveSearchCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for DriveSearch
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public DriveSearchCollectionPage(@Nonnull final java.util.List<DriveItem> pageContents, @Nullable final DriveSearchCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
