// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserFlowLanguageConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Flow Language Configuration Request.
 */
public class UserFlowLanguageConfigurationRequest extends BaseRequest<UserFlowLanguageConfiguration> {
	
    /**
     * The request for the UserFlowLanguageConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserFlowLanguageConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserFlowLanguageConfiguration.class);
    }

    /**
     * Gets the UserFlowLanguageConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserFlowLanguageConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserFlowLanguageConfiguration from the service
     *
     * @return the UserFlowLanguageConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserFlowLanguageConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserFlowLanguageConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserFlowLanguageConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserFlowLanguageConfiguration with a source
     *
     * @param sourceUserFlowLanguageConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserFlowLanguageConfiguration> patchAsync(@Nonnull final UserFlowLanguageConfiguration sourceUserFlowLanguageConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceUserFlowLanguageConfiguration);
    }

    /**
     * Patches this UserFlowLanguageConfiguration with a source
     *
     * @param sourceUserFlowLanguageConfiguration the source object with updates
     * @return the updated UserFlowLanguageConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserFlowLanguageConfiguration patch(@Nonnull final UserFlowLanguageConfiguration sourceUserFlowLanguageConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserFlowLanguageConfiguration);
    }

    /**
     * Creates a UserFlowLanguageConfiguration with a new object
     *
     * @param newUserFlowLanguageConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserFlowLanguageConfiguration> postAsync(@Nonnull final UserFlowLanguageConfiguration newUserFlowLanguageConfiguration) {
        return sendAsync(HttpMethod.POST, newUserFlowLanguageConfiguration);
    }

    /**
     * Creates a UserFlowLanguageConfiguration with a new object
     *
     * @param newUserFlowLanguageConfiguration the new object to create
     * @return the created UserFlowLanguageConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserFlowLanguageConfiguration post(@Nonnull final UserFlowLanguageConfiguration newUserFlowLanguageConfiguration) throws ClientException {
        return send(HttpMethod.POST, newUserFlowLanguageConfiguration);
    }

    /**
     * Creates a UserFlowLanguageConfiguration with a new object
     *
     * @param newUserFlowLanguageConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserFlowLanguageConfiguration> putAsync(@Nonnull final UserFlowLanguageConfiguration newUserFlowLanguageConfiguration) {
        return sendAsync(HttpMethod.PUT, newUserFlowLanguageConfiguration);
    }

    /**
     * Creates a UserFlowLanguageConfiguration with a new object
     *
     * @param newUserFlowLanguageConfiguration the object to create/update
     * @return the created UserFlowLanguageConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserFlowLanguageConfiguration put(@Nonnull final UserFlowLanguageConfiguration newUserFlowLanguageConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newUserFlowLanguageConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserFlowLanguageConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserFlowLanguageConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

