// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.BookingStaffRole;
import com.microsoft.graph.models.BookingWorkHours;
import com.microsoft.graph.models.BookingStaffMemberBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Staff Member.
 */
public class BookingStaffMember extends BookingStaffMemberBase implements IJsonBackedObject {


    /**
     * The Availability Is Affected By Personal Calendar.
     * True means that if the staff member is a Microsoft 365 user, the Bookings API would verify the staff member's availability in their personal calendar in Microsoft 365, before making a booking.
     */
    @SerializedName(value = "availabilityIsAffectedByPersonalCalendar", alternate = {"AvailabilityIsAffectedByPersonalCalendar"})
    @Expose
	@Nullable
    public Boolean availabilityIsAffectedByPersonalCalendar;

    /**
     * The Display Name.
     * The display name is suitable for human-readable interfaces.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Email Address.
     * The email address of the staff member. This can be in the same Microsoft 365 tenant as the business, or in a different email domain. This email address can be used if the sendConfirmationsToOwner property is set to true in the scheduling policy of the business. Required.
     */
    @SerializedName(value = "emailAddress", alternate = {"EmailAddress"})
    @Expose
	@Nullable
    public String emailAddress;

    /**
     * The Is Email Notification Enabled.
     * 
     */
    @SerializedName(value = "isEmailNotificationEnabled", alternate = {"IsEmailNotificationEnabled"})
    @Expose
	@Nullable
    public Boolean isEmailNotificationEnabled;

    /**
     * The Role.
     * The role of the staff member in the business. Possible values are: guest, administrator, viewer, externalGuest and unknownFutureValue. Required.
     */
    @SerializedName(value = "role", alternate = {"Role"})
    @Expose
	@Nullable
    public BookingStaffRole role;

    /**
     * The Time Zone.
     * The time zone of the staff member. For a list of possible values, see dateTimeTimeZone.
     */
    @SerializedName(value = "timeZone", alternate = {"TimeZone"})
    @Expose
	@Nullable
    public String timeZone;

    /**
     * The Use Business Hours.
     * True means the staff member's availability is as specified in the businessHours property of the business. False means the availability is determined by the staff member's workingHours property setting.
     */
    @SerializedName(value = "useBusinessHours", alternate = {"UseBusinessHours"})
    @Expose
	@Nullable
    public Boolean useBusinessHours;

    /**
     * The Working Hours.
     * The range of hours each day of the week that the staff member is available for booking. By default, they are initialized to be the same as the businessHours property of the business.
     */
    @SerializedName(value = "workingHours", alternate = {"WorkingHours"})
    @Expose
	@Nullable
    public java.util.List<BookingWorkHours> workingHours;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
