// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.security.models.SourceType;
import com.microsoft.graph.security.models.DataSource;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Source.
 */
public class UserSource extends DataSource implements IJsonBackedObject {


    /**
     * The Email.
     * Email address of the user's mailbox.
     */
    @SerializedName(value = "email", alternate = {"Email"})
    @Expose
	@Nullable
    public String email;

    /**
     * The Included Sources.
     * Specifies which sources are included in this group. Possible values are: mailbox, site.
     */
    @SerializedName(value = "includedSources", alternate = {"IncludedSources"})
    @Expose
	@Nullable
    public EnumSet<SourceType> includedSources;

    /**
     * The Site Web Url.
     * The URL of the user's OneDrive for Business site. Read-only.
     */
    @SerializedName(value = "siteWebUrl", alternate = {"SiteWebUrl"})
    @Expose
	@Nullable
    public String siteWebUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
