// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingStaffMember;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Staff Member Request.
 */
public class BookingStaffMemberRequest extends BaseRequest<BookingStaffMember> {
	
    /**
     * The request for the BookingStaffMember
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingStaffMemberRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingStaffMember.class);
    }

    /**
     * Gets the BookingStaffMember from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMember> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BookingStaffMember from the service
     *
     * @return the BookingStaffMember from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMember get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMember> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BookingStaffMember delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BookingStaffMember with a source
     *
     * @param sourceBookingStaffMember the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMember> patchAsync(@Nonnull final BookingStaffMember sourceBookingStaffMember) {
        return sendAsync(HttpMethod.PATCH, sourceBookingStaffMember);
    }

    /**
     * Patches this BookingStaffMember with a source
     *
     * @param sourceBookingStaffMember the source object with updates
     * @return the updated BookingStaffMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMember patch(@Nonnull final BookingStaffMember sourceBookingStaffMember) throws ClientException {
        return send(HttpMethod.PATCH, sourceBookingStaffMember);
    }

    /**
     * Creates a BookingStaffMember with a new object
     *
     * @param newBookingStaffMember the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMember> postAsync(@Nonnull final BookingStaffMember newBookingStaffMember) {
        return sendAsync(HttpMethod.POST, newBookingStaffMember);
    }

    /**
     * Creates a BookingStaffMember with a new object
     *
     * @param newBookingStaffMember the new object to create
     * @return the created BookingStaffMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMember post(@Nonnull final BookingStaffMember newBookingStaffMember) throws ClientException {
        return send(HttpMethod.POST, newBookingStaffMember);
    }

    /**
     * Creates a BookingStaffMember with a new object
     *
     * @param newBookingStaffMember the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingStaffMember> putAsync(@Nonnull final BookingStaffMember newBookingStaffMember) {
        return sendAsync(HttpMethod.PUT, newBookingStaffMember);
    }

    /**
     * Creates a BookingStaffMember with a new object
     *
     * @param newBookingStaffMember the object to create/update
     * @return the created BookingStaffMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingStaffMember put(@Nonnull final BookingStaffMember newBookingStaffMember) throws ClientException {
        return send(HttpMethod.PUT, newBookingStaffMember);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BookingStaffMemberRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BookingStaffMemberRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

