// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.CallCollectionPage;
import com.microsoft.graph.callrecords.requests.CallRecordCollectionPage;
import com.microsoft.graph.requests.OnlineMeetingCollectionPage;
import com.microsoft.graph.requests.PresenceCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cloud Communications.
 */
public class CloudCommunications extends Entity implements IJsonBackedObject {


    /**
     * The Calls.
     * 
     */
    @SerializedName(value = "calls", alternate = {"Calls"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.CallCollectionPage calls;

    /**
     * The Call Records.
     * 
     */
    @SerializedName(value = "callRecords", alternate = {"CallRecords"})
    @Expose
	@Nullable
    public com.microsoft.graph.callrecords.requests.CallRecordCollectionPage callRecords;

    /**
     * The Online Meetings.
     * 
     */
    @SerializedName(value = "onlineMeetings", alternate = {"OnlineMeetings"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.OnlineMeetingCollectionPage onlineMeetings;

    /**
     * The Presences.
     * 
     */
    @SerializedName(value = "presences", alternate = {"Presences"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PresenceCollectionPage presences;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("calls")) {
            calls = serializer.deserializeObject(json.get("calls"), com.microsoft.graph.requests.CallCollectionPage.class);
        }

        if (json.has("callRecords")) {
            callRecords = serializer.deserializeObject(json.get("callRecords"), com.microsoft.graph.callrecords.requests.CallRecordCollectionPage.class);
        }

        if (json.has("onlineMeetings")) {
            onlineMeetings = serializer.deserializeObject(json.get("onlineMeetings"), com.microsoft.graph.requests.OnlineMeetingCollectionPage.class);
        }

        if (json.has("presences")) {
            presences = serializer.deserializeObject(json.get("presences"), com.microsoft.graph.requests.PresenceCollectionPage.class);
        }
    }
}
