// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.CrossTenantAccessPolicyB2BSetting;
import com.microsoft.graph.models.CrossTenantAccessPolicyInboundTrust;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cross Tenant Access Policy Configuration Partner.
 */
public class CrossTenantAccessPolicyConfigurationPartner implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The B2b Collaboration Inbound.
     * Defines your partner-specific configuration for users from other organizations accessing your resources via Azure AD B2B collaboration.
     */
    @SerializedName(value = "b2bCollaborationInbound", alternate = {"B2bCollaborationInbound"})
    @Expose
	@Nullable
    public CrossTenantAccessPolicyB2BSetting b2bCollaborationInbound;

    /**
     * The B2b Collaboration Outbound.
     * Defines your partner-specific configuration for users in your organization going outbound to access resources in another organization via Azure AD B2B collaboration.
     */
    @SerializedName(value = "b2bCollaborationOutbound", alternate = {"B2bCollaborationOutbound"})
    @Expose
	@Nullable
    public CrossTenantAccessPolicyB2BSetting b2bCollaborationOutbound;

    /**
     * The B2b Direct Connect Inbound.
     * Defines your partner-specific configuration for users from other organizations accessing your resources via Azure B2B direct connect.
     */
    @SerializedName(value = "b2bDirectConnectInbound", alternate = {"B2bDirectConnectInbound"})
    @Expose
	@Nullable
    public CrossTenantAccessPolicyB2BSetting b2bDirectConnectInbound;

    /**
     * The B2b Direct Connect Outbound.
     * Defines your partner-specific configuration for users in your organization going outbound to access resources in another organization via Azure AD B2B direct connect.
     */
    @SerializedName(value = "b2bDirectConnectOutbound", alternate = {"B2bDirectConnectOutbound"})
    @Expose
	@Nullable
    public CrossTenantAccessPolicyB2BSetting b2bDirectConnectOutbound;

    /**
     * The Inbound Trust.
     * Determines the partner-specific configuration for trusting other Conditional Access claims from external Azure AD organizations.
     */
    @SerializedName(value = "inboundTrust", alternate = {"InboundTrust"})
    @Expose
	@Nullable
    public CrossTenantAccessPolicyInboundTrust inboundTrust;

    /**
     * The Is Service Provider.
     * Identifies whether the partner-specific configuration is a Cloud Service Provider for your organization.
     */
    @SerializedName(value = "isServiceProvider", alternate = {"IsServiceProvider"})
    @Expose
	@Nullable
    public Boolean isServiceProvider;

    /**
     * The Tenant Id.
     * The tenant identifier for the partner Azure AD organization. Read-only. Key.
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
