// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TodoTask;
import com.microsoft.graph.models.AttachmentBase;
import com.microsoft.graph.models.AttachmentInfo;
import com.microsoft.graph.models.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AttachmentBaseCollectionRequestBuilder;
import com.microsoft.graph.requests.AttachmentBaseRequestBuilder;
import com.microsoft.graph.requests.AttachmentBaseCollectionRequest;
import com.microsoft.graph.requests.AttachmentBaseCreateUploadSessionRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.AttachmentBaseCreateUploadSessionParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attachment Base Collection Request Builder.
 */
public class AttachmentBaseCollectionRequestBuilder extends BaseCollectionRequestBuilder<AttachmentBase, AttachmentBaseRequestBuilder, AttachmentBaseCollectionResponse, AttachmentBaseCollectionPage, AttachmentBaseCollectionRequest> {

    /**
     * The request builder for this collection of TodoTask
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AttachmentBaseCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttachmentBaseRequestBuilder.class, AttachmentBaseCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public AttachmentBaseCreateUploadSessionRequestBuilder createUploadSession(@Nonnull final AttachmentBaseCreateUploadSessionParameterSet parameters) {
        return new AttachmentBaseCreateUploadSessionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.createUploadSession"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
