// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.MacOSLobChildApp;
import com.microsoft.graph.models.MacOSMinimumOperatingSystem;
import com.microsoft.graph.models.MobileLobApp;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSLob App.
 */
public class MacOSLobApp extends MobileLobApp implements IJsonBackedObject {


    /**
     * The Build Number.
     * The build number of the package. This should match the package CFBundleShortVersionString of the .pkg file.
     */
    @SerializedName(value = "buildNumber", alternate = {"BuildNumber"})
    @Expose
	@Nullable
    public String buildNumber;

    /**
     * The Bundle Id.
     * The primary bundleId of the package.
     */
    @SerializedName(value = "bundleId", alternate = {"BundleId"})
    @Expose
	@Nullable
    public String bundleId;

    /**
     * The Child Apps.
     * List of ComplexType macOSLobChildApp objects. Represents the apps expected to be installed by the package.
     */
    @SerializedName(value = "childApps", alternate = {"ChildApps"})
    @Expose
	@Nullable
    public java.util.List<MacOSLobChildApp> childApps;

    /**
     * The Ignore Version Detection.
     * When TRUE, indicates that the app's version will NOT be used to detect if the app is installed on a device. When FALSE, indicates that the app's version will be used to detect if the app is installed on a device. Set this to true for apps that use a self update feature.
     */
    @SerializedName(value = "ignoreVersionDetection", alternate = {"IgnoreVersionDetection"})
    @Expose
	@Nullable
    public Boolean ignoreVersionDetection;

    /**
     * The Install As Managed.
     * When TRUE, indicates that the app will be installed as managed (requires macOS 11.0 and other managed package restrictions). When FALSE, indicates that the app will be installed as unmanaged.
     */
    @SerializedName(value = "installAsManaged", alternate = {"InstallAsManaged"})
    @Expose
	@Nullable
    public Boolean installAsManaged;

    /**
     * The Md5Hash.
     * The MD5 hash codes. This is empty if the package was uploaded directly. If the Intune App Wrapping Tool is used to create a .intunemac, this value can be found inside the Detection.xml file.
     */
    @SerializedName(value = "md5Hash", alternate = {"Md5Hash"})
    @Expose
	@Nullable
    public java.util.List<String> md5Hash;

    /**
     * The Md5Hash Chunk Size.
     * The chunk size for MD5 hash. This is '0' or empty if the package was uploaded directly. If the Intune App Wrapping Tool is used to create a .intunemac, this value can be found inside the Detection.xml file.
     */
    @SerializedName(value = "md5HashChunkSize", alternate = {"Md5HashChunkSize"})
    @Expose
	@Nullable
    public Integer md5HashChunkSize;

    /**
     * The Minimum Supported Operating System.
     * ComplexType macOSMinimumOperatingSystem that indicates the minimum operating system applicable for the application.
     */
    @SerializedName(value = "minimumSupportedOperatingSystem", alternate = {"MinimumSupportedOperatingSystem"})
    @Expose
	@Nullable
    public MacOSMinimumOperatingSystem minimumSupportedOperatingSystem;

    /**
     * The Version Number.
     * The version number of the package. This should match the package CFBundleVersion in the packageinfo file.
     */
    @SerializedName(value = "versionNumber", alternate = {"VersionNumber"})
    @Expose
	@Nullable
    public String versionNumber;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
