// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AppManagementConfiguration;
import com.microsoft.graph.models.PolicyBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tenant App Management Policy.
 */
public class TenantAppManagementPolicy extends PolicyBase implements IJsonBackedObject {


    /**
     * The Application Restrictions.
     * 
     */
    @SerializedName(value = "applicationRestrictions", alternate = {"ApplicationRestrictions"})
    @Expose
	@Nullable
    public AppManagementConfiguration applicationRestrictions;

    /**
     * The Is Enabled.
     * 
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Service Principal Restrictions.
     * 
     */
    @SerializedName(value = "servicePrincipalRestrictions", alternate = {"ServicePrincipalRestrictions"})
    @Expose
	@Nullable
    public AppManagementConfiguration servicePrincipalRestrictions;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
