// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AzureCommunicationServicesUserConversationMember;
import com.microsoft.graph.models.ConversationMember;
import com.microsoft.graph.models.ActionResultPart;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Azure Communication Services User Conversation Member Request.
 */
public class AzureCommunicationServicesUserConversationMemberRequest extends BaseRequest<AzureCommunicationServicesUserConversationMember> {
	
    /**
     * The request for the AzureCommunicationServicesUserConversationMember
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AzureCommunicationServicesUserConversationMemberRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AzureCommunicationServicesUserConversationMember.class);
    }

    /**
     * Gets the AzureCommunicationServicesUserConversationMember from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AzureCommunicationServicesUserConversationMember> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AzureCommunicationServicesUserConversationMember from the service
     *
     * @return the AzureCommunicationServicesUserConversationMember from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AzureCommunicationServicesUserConversationMember get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AzureCommunicationServicesUserConversationMember> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AzureCommunicationServicesUserConversationMember delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AzureCommunicationServicesUserConversationMember with a source
     *
     * @param sourceAzureCommunicationServicesUserConversationMember the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AzureCommunicationServicesUserConversationMember> patchAsync(@Nonnull final AzureCommunicationServicesUserConversationMember sourceAzureCommunicationServicesUserConversationMember) {
        return sendAsync(HttpMethod.PATCH, sourceAzureCommunicationServicesUserConversationMember);
    }

    /**
     * Patches this AzureCommunicationServicesUserConversationMember with a source
     *
     * @param sourceAzureCommunicationServicesUserConversationMember the source object with updates
     * @return the updated AzureCommunicationServicesUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AzureCommunicationServicesUserConversationMember patch(@Nonnull final AzureCommunicationServicesUserConversationMember sourceAzureCommunicationServicesUserConversationMember) throws ClientException {
        return send(HttpMethod.PATCH, sourceAzureCommunicationServicesUserConversationMember);
    }

    /**
     * Creates a AzureCommunicationServicesUserConversationMember with a new object
     *
     * @param newAzureCommunicationServicesUserConversationMember the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AzureCommunicationServicesUserConversationMember> postAsync(@Nonnull final AzureCommunicationServicesUserConversationMember newAzureCommunicationServicesUserConversationMember) {
        return sendAsync(HttpMethod.POST, newAzureCommunicationServicesUserConversationMember);
    }

    /**
     * Creates a AzureCommunicationServicesUserConversationMember with a new object
     *
     * @param newAzureCommunicationServicesUserConversationMember the new object to create
     * @return the created AzureCommunicationServicesUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AzureCommunicationServicesUserConversationMember post(@Nonnull final AzureCommunicationServicesUserConversationMember newAzureCommunicationServicesUserConversationMember) throws ClientException {
        return send(HttpMethod.POST, newAzureCommunicationServicesUserConversationMember);
    }

    /**
     * Creates a AzureCommunicationServicesUserConversationMember with a new object
     *
     * @param newAzureCommunicationServicesUserConversationMember the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AzureCommunicationServicesUserConversationMember> putAsync(@Nonnull final AzureCommunicationServicesUserConversationMember newAzureCommunicationServicesUserConversationMember) {
        return sendAsync(HttpMethod.PUT, newAzureCommunicationServicesUserConversationMember);
    }

    /**
     * Creates a AzureCommunicationServicesUserConversationMember with a new object
     *
     * @param newAzureCommunicationServicesUserConversationMember the object to create/update
     * @return the created AzureCommunicationServicesUserConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AzureCommunicationServicesUserConversationMember put(@Nonnull final AzureCommunicationServicesUserConversationMember newAzureCommunicationServicesUserConversationMember) throws ClientException {
        return send(HttpMethod.PUT, newAzureCommunicationServicesUserConversationMember);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AzureCommunicationServicesUserConversationMemberRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AzureCommunicationServicesUserConversationMemberRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

