// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PinnedChatMessageInfo;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Pinned Chat Message Info Request.
 */
public class PinnedChatMessageInfoRequest extends BaseRequest<PinnedChatMessageInfo> {
	
    /**
     * The request for the PinnedChatMessageInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PinnedChatMessageInfoRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PinnedChatMessageInfo.class);
    }

    /**
     * Gets the PinnedChatMessageInfo from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PinnedChatMessageInfo> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PinnedChatMessageInfo from the service
     *
     * @return the PinnedChatMessageInfo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PinnedChatMessageInfo get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PinnedChatMessageInfo> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PinnedChatMessageInfo delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PinnedChatMessageInfo with a source
     *
     * @param sourcePinnedChatMessageInfo the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PinnedChatMessageInfo> patchAsync(@Nonnull final PinnedChatMessageInfo sourcePinnedChatMessageInfo) {
        return sendAsync(HttpMethod.PATCH, sourcePinnedChatMessageInfo);
    }

    /**
     * Patches this PinnedChatMessageInfo with a source
     *
     * @param sourcePinnedChatMessageInfo the source object with updates
     * @return the updated PinnedChatMessageInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PinnedChatMessageInfo patch(@Nonnull final PinnedChatMessageInfo sourcePinnedChatMessageInfo) throws ClientException {
        return send(HttpMethod.PATCH, sourcePinnedChatMessageInfo);
    }

    /**
     * Creates a PinnedChatMessageInfo with a new object
     *
     * @param newPinnedChatMessageInfo the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PinnedChatMessageInfo> postAsync(@Nonnull final PinnedChatMessageInfo newPinnedChatMessageInfo) {
        return sendAsync(HttpMethod.POST, newPinnedChatMessageInfo);
    }

    /**
     * Creates a PinnedChatMessageInfo with a new object
     *
     * @param newPinnedChatMessageInfo the new object to create
     * @return the created PinnedChatMessageInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PinnedChatMessageInfo post(@Nonnull final PinnedChatMessageInfo newPinnedChatMessageInfo) throws ClientException {
        return send(HttpMethod.POST, newPinnedChatMessageInfo);
    }

    /**
     * Creates a PinnedChatMessageInfo with a new object
     *
     * @param newPinnedChatMessageInfo the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PinnedChatMessageInfo> putAsync(@Nonnull final PinnedChatMessageInfo newPinnedChatMessageInfo) {
        return sendAsync(HttpMethod.PUT, newPinnedChatMessageInfo);
    }

    /**
     * Creates a PinnedChatMessageInfo with a new object
     *
     * @param newPinnedChatMessageInfo the object to create/update
     * @return the created PinnedChatMessageInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PinnedChatMessageInfo put(@Nonnull final PinnedChatMessageInfo newPinnedChatMessageInfo) throws ClientException {
        return send(HttpMethod.PUT, newPinnedChatMessageInfo);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PinnedChatMessageInfoRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PinnedChatMessageInfoRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

