// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Windows81GeneralConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows81General Configuration Request.
 */
public class Windows81GeneralConfigurationRequest extends BaseRequest<Windows81GeneralConfiguration> {
	
    /**
     * The request for the Windows81GeneralConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public Windows81GeneralConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Windows81GeneralConfiguration.class);
    }

    /**
     * Gets the Windows81GeneralConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81GeneralConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Windows81GeneralConfiguration from the service
     *
     * @return the Windows81GeneralConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81GeneralConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81GeneralConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Windows81GeneralConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Windows81GeneralConfiguration with a source
     *
     * @param sourceWindows81GeneralConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81GeneralConfiguration> patchAsync(@Nonnull final Windows81GeneralConfiguration sourceWindows81GeneralConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceWindows81GeneralConfiguration);
    }

    /**
     * Patches this Windows81GeneralConfiguration with a source
     *
     * @param sourceWindows81GeneralConfiguration the source object with updates
     * @return the updated Windows81GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81GeneralConfiguration patch(@Nonnull final Windows81GeneralConfiguration sourceWindows81GeneralConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindows81GeneralConfiguration);
    }

    /**
     * Creates a Windows81GeneralConfiguration with a new object
     *
     * @param newWindows81GeneralConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81GeneralConfiguration> postAsync(@Nonnull final Windows81GeneralConfiguration newWindows81GeneralConfiguration) {
        return sendAsync(HttpMethod.POST, newWindows81GeneralConfiguration);
    }

    /**
     * Creates a Windows81GeneralConfiguration with a new object
     *
     * @param newWindows81GeneralConfiguration the new object to create
     * @return the created Windows81GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81GeneralConfiguration post(@Nonnull final Windows81GeneralConfiguration newWindows81GeneralConfiguration) throws ClientException {
        return send(HttpMethod.POST, newWindows81GeneralConfiguration);
    }

    /**
     * Creates a Windows81GeneralConfiguration with a new object
     *
     * @param newWindows81GeneralConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Windows81GeneralConfiguration> putAsync(@Nonnull final Windows81GeneralConfiguration newWindows81GeneralConfiguration) {
        return sendAsync(HttpMethod.PUT, newWindows81GeneralConfiguration);
    }

    /**
     * Creates a Windows81GeneralConfiguration with a new object
     *
     * @param newWindows81GeneralConfiguration the object to create/update
     * @return the created Windows81GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Windows81GeneralConfiguration put(@Nonnull final Windows81GeneralConfiguration newWindows81GeneralConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newWindows81GeneralConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public Windows81GeneralConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public Windows81GeneralConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

