// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.DataSourceContainer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Data Source Container Request.
 */
public class DataSourceContainerRequest extends BaseRequest<DataSourceContainer> {
	
    /**
     * The request for the DataSourceContainer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public DataSourceContainerRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends DataSourceContainer> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the DataSourceContainer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DataSourceContainerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSourceContainer.class);
    }

    /**
     * Gets the DataSourceContainer from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSourceContainer> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DataSourceContainer from the service
     *
     * @return the DataSourceContainer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSourceContainer get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSourceContainer> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DataSourceContainer delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DataSourceContainer with a source
     *
     * @param sourceDataSourceContainer the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSourceContainer> patchAsync(@Nonnull final DataSourceContainer sourceDataSourceContainer) {
        return sendAsync(HttpMethod.PATCH, sourceDataSourceContainer);
    }

    /**
     * Patches this DataSourceContainer with a source
     *
     * @param sourceDataSourceContainer the source object with updates
     * @return the updated DataSourceContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSourceContainer patch(@Nonnull final DataSourceContainer sourceDataSourceContainer) throws ClientException {
        return send(HttpMethod.PATCH, sourceDataSourceContainer);
    }

    /**
     * Creates a DataSourceContainer with a new object
     *
     * @param newDataSourceContainer the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSourceContainer> postAsync(@Nonnull final DataSourceContainer newDataSourceContainer) {
        return sendAsync(HttpMethod.POST, newDataSourceContainer);
    }

    /**
     * Creates a DataSourceContainer with a new object
     *
     * @param newDataSourceContainer the new object to create
     * @return the created DataSourceContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSourceContainer post(@Nonnull final DataSourceContainer newDataSourceContainer) throws ClientException {
        return send(HttpMethod.POST, newDataSourceContainer);
    }

    /**
     * Creates a DataSourceContainer with a new object
     *
     * @param newDataSourceContainer the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DataSourceContainer> putAsync(@Nonnull final DataSourceContainer newDataSourceContainer) {
        return sendAsync(HttpMethod.PUT, newDataSourceContainer);
    }

    /**
     * Creates a DataSourceContainer with a new object
     *
     * @param newDataSourceContainer the object to create/update
     * @return the created DataSourceContainer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DataSourceContainer put(@Nonnull final DataSourceContainer newDataSourceContainer) throws ClientException {
        return send(HttpMethod.PUT, newDataSourceContainer);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DataSourceContainerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DataSourceContainerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

