// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ContentType;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.SiteGetApplicableContentTypesForListCollectionRequestBuilder;
import com.microsoft.graph.requests.SiteGetApplicableContentTypesForListCollectionRequest;
import com.microsoft.graph.requests.SiteGetApplicableContentTypesForListCollectionResponse;
import com.microsoft.graph.models.SiteGetApplicableContentTypesForListParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Get Applicable Content Types For List Collection Request Builder.
 */
public class SiteGetApplicableContentTypesForListCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<ContentType, SiteGetApplicableContentTypesForListCollectionRequestBuilder, SiteGetApplicableContentTypesForListCollectionResponse, SiteGetApplicableContentTypesForListCollectionPage, SiteGetApplicableContentTypesForListCollectionRequest> {

    /**
     * The request builder for this collection of Site
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SiteGetApplicableContentTypesForListCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteGetApplicableContentTypesForListCollectionRequestBuilder.class, SiteGetApplicableContentTypesForListCollectionRequest.class);
    }
    /**
     * The request builder for this collection of Site
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public SiteGetApplicableContentTypesForListCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final SiteGetApplicableContentTypesForListParameterSet parameters) {
        super(requestUrl, client, requestOptions, SiteGetApplicableContentTypesForListCollectionRequestBuilder.class, SiteGetApplicableContentTypesForListCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SiteGetApplicableContentTypesForListCollectionRequest instance
     */
    @Override
    @Nonnull
    public SiteGetApplicableContentTypesForListCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final SiteGetApplicableContentTypesForListCollectionRequest request = super.buildRequest(requestOptions);
          for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }
        return request;
    }
}
