// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ThreatAssessmentResult;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Threat Assessment Result Request.
 */
public class ThreatAssessmentResultRequest extends BaseRequest<ThreatAssessmentResult> {
	
    /**
     * The request for the ThreatAssessmentResult
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ThreatAssessmentResultRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThreatAssessmentResult.class);
    }

    /**
     * Gets the ThreatAssessmentResult from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentResult> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ThreatAssessmentResult from the service
     *
     * @return the ThreatAssessmentResult from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentResult get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentResult> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ThreatAssessmentResult delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ThreatAssessmentResult with a source
     *
     * @param sourceThreatAssessmentResult the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentResult> patchAsync(@Nonnull final ThreatAssessmentResult sourceThreatAssessmentResult) {
        return sendAsync(HttpMethod.PATCH, sourceThreatAssessmentResult);
    }

    /**
     * Patches this ThreatAssessmentResult with a source
     *
     * @param sourceThreatAssessmentResult the source object with updates
     * @return the updated ThreatAssessmentResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentResult patch(@Nonnull final ThreatAssessmentResult sourceThreatAssessmentResult) throws ClientException {
        return send(HttpMethod.PATCH, sourceThreatAssessmentResult);
    }

    /**
     * Creates a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentResult> postAsync(@Nonnull final ThreatAssessmentResult newThreatAssessmentResult) {
        return sendAsync(HttpMethod.POST, newThreatAssessmentResult);
    }

    /**
     * Creates a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the new object to create
     * @return the created ThreatAssessmentResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentResult post(@Nonnull final ThreatAssessmentResult newThreatAssessmentResult) throws ClientException {
        return send(HttpMethod.POST, newThreatAssessmentResult);
    }

    /**
     * Creates a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ThreatAssessmentResult> putAsync(@Nonnull final ThreatAssessmentResult newThreatAssessmentResult) {
        return sendAsync(HttpMethod.PUT, newThreatAssessmentResult);
    }

    /**
     * Creates a ThreatAssessmentResult with a new object
     *
     * @param newThreatAssessmentResult the object to create/update
     * @return the created ThreatAssessmentResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ThreatAssessmentResult put(@Nonnull final ThreatAssessmentResult newThreatAssessmentResult) throws ClientException {
        return send(HttpMethod.PUT, newThreatAssessmentResult);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ThreatAssessmentResultRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ThreatAssessmentResultRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

