// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdleSessionSignOut;
import com.microsoft.graph.models.ImageTaggingChoice;
import com.microsoft.graph.models.SharingCapabilities;
import com.microsoft.graph.models.SharingDomainRestrictionMode;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sharepoint Settings.
 */
public class SharepointSettings extends Entity implements IJsonBackedObject {


    /**
     * The Allowed Domain Guids For Sync App.
     * 
     */
    @SerializedName(value = "allowedDomainGuidsForSyncApp", alternate = {"AllowedDomainGuidsForSyncApp"})
    @Expose
	@Nullable
    public java.util.List<java.util.UUID> allowedDomainGuidsForSyncApp;

    /**
     * The Available Managed Paths For Site Creation.
     * 
     */
    @SerializedName(value = "availableManagedPathsForSiteCreation", alternate = {"AvailableManagedPathsForSiteCreation"})
    @Expose
	@Nullable
    public java.util.List<String> availableManagedPathsForSiteCreation;

    /**
     * The Deleted User Personal Site Retention Period In Days.
     * 
     */
    @SerializedName(value = "deletedUserPersonalSiteRetentionPeriodInDays", alternate = {"DeletedUserPersonalSiteRetentionPeriodInDays"})
    @Expose
	@Nullable
    public Integer deletedUserPersonalSiteRetentionPeriodInDays;

    /**
     * The Excluded File Extensions For Sync App.
     * 
     */
    @SerializedName(value = "excludedFileExtensionsForSyncApp", alternate = {"ExcludedFileExtensionsForSyncApp"})
    @Expose
	@Nullable
    public java.util.List<String> excludedFileExtensionsForSyncApp;

    /**
     * The Idle Session Sign Out.
     * 
     */
    @SerializedName(value = "idleSessionSignOut", alternate = {"IdleSessionSignOut"})
    @Expose
	@Nullable
    public IdleSessionSignOut idleSessionSignOut;

    /**
     * The Image Tagging Option.
     * 
     */
    @SerializedName(value = "imageTaggingOption", alternate = {"ImageTaggingOption"})
    @Expose
	@Nullable
    public ImageTaggingChoice imageTaggingOption;

    /**
     * The Is Commenting On Site Pages Enabled.
     * 
     */
    @SerializedName(value = "isCommentingOnSitePagesEnabled", alternate = {"IsCommentingOnSitePagesEnabled"})
    @Expose
	@Nullable
    public Boolean isCommentingOnSitePagesEnabled;

    /**
     * The Is File Activity Notification Enabled.
     * 
     */
    @SerializedName(value = "isFileActivityNotificationEnabled", alternate = {"IsFileActivityNotificationEnabled"})
    @Expose
	@Nullable
    public Boolean isFileActivityNotificationEnabled;

    /**
     * The Is Legacy Auth Protocols Enabled.
     * 
     */
    @SerializedName(value = "isLegacyAuthProtocolsEnabled", alternate = {"IsLegacyAuthProtocolsEnabled"})
    @Expose
	@Nullable
    public Boolean isLegacyAuthProtocolsEnabled;

    /**
     * The Is Loop Enabled.
     * 
     */
    @SerializedName(value = "isLoopEnabled", alternate = {"IsLoopEnabled"})
    @Expose
	@Nullable
    public Boolean isLoopEnabled;

    /**
     * The Is Mac Sync App Enabled.
     * 
     */
    @SerializedName(value = "isMacSyncAppEnabled", alternate = {"IsMacSyncAppEnabled"})
    @Expose
	@Nullable
    public Boolean isMacSyncAppEnabled;

    /**
     * The Is Require Accepting User To Match Invited User Enabled.
     * 
     */
    @SerializedName(value = "isRequireAcceptingUserToMatchInvitedUserEnabled", alternate = {"IsRequireAcceptingUserToMatchInvitedUserEnabled"})
    @Expose
	@Nullable
    public Boolean isRequireAcceptingUserToMatchInvitedUserEnabled;

    /**
     * The Is Resharing By External Users Enabled.
     * 
     */
    @SerializedName(value = "isResharingByExternalUsersEnabled", alternate = {"IsResharingByExternalUsersEnabled"})
    @Expose
	@Nullable
    public Boolean isResharingByExternalUsersEnabled;

    /**
     * The Is Share Point Mobile Notification Enabled.
     * 
     */
    @SerializedName(value = "isSharePointMobileNotificationEnabled", alternate = {"IsSharePointMobileNotificationEnabled"})
    @Expose
	@Nullable
    public Boolean isSharePointMobileNotificationEnabled;

    /**
     * The Is Share Point Newsfeed Enabled.
     * 
     */
    @SerializedName(value = "isSharePointNewsfeedEnabled", alternate = {"IsSharePointNewsfeedEnabled"})
    @Expose
	@Nullable
    public Boolean isSharePointNewsfeedEnabled;

    /**
     * The Is Site Creation Enabled.
     * 
     */
    @SerializedName(value = "isSiteCreationEnabled", alternate = {"IsSiteCreationEnabled"})
    @Expose
	@Nullable
    public Boolean isSiteCreationEnabled;

    /**
     * The Is Site Creation UIEnabled.
     * 
     */
    @SerializedName(value = "isSiteCreationUIEnabled", alternate = {"IsSiteCreationUIEnabled"})
    @Expose
	@Nullable
    public Boolean isSiteCreationUIEnabled;

    /**
     * The Is Site Pages Creation Enabled.
     * 
     */
    @SerializedName(value = "isSitePagesCreationEnabled", alternate = {"IsSitePagesCreationEnabled"})
    @Expose
	@Nullable
    public Boolean isSitePagesCreationEnabled;

    /**
     * The Is Sites Storage Limit Automatic.
     * 
     */
    @SerializedName(value = "isSitesStorageLimitAutomatic", alternate = {"IsSitesStorageLimitAutomatic"})
    @Expose
	@Nullable
    public Boolean isSitesStorageLimitAutomatic;

    /**
     * The Is Sync Button Hidden On Personal Site.
     * 
     */
    @SerializedName(value = "isSyncButtonHiddenOnPersonalSite", alternate = {"IsSyncButtonHiddenOnPersonalSite"})
    @Expose
	@Nullable
    public Boolean isSyncButtonHiddenOnPersonalSite;

    /**
     * The Is Unmanaged Sync App For Tenant Restricted.
     * 
     */
    @SerializedName(value = "isUnmanagedSyncAppForTenantRestricted", alternate = {"IsUnmanagedSyncAppForTenantRestricted"})
    @Expose
	@Nullable
    public Boolean isUnmanagedSyncAppForTenantRestricted;

    /**
     * The Personal Site Default Storage Limit In MB.
     * 
     */
    @SerializedName(value = "personalSiteDefaultStorageLimitInMB", alternate = {"PersonalSiteDefaultStorageLimitInMB"})
    @Expose
	@Nullable
    public Long personalSiteDefaultStorageLimitInMB;

    /**
     * The Sharing Allowed Domain List.
     * 
     */
    @SerializedName(value = "sharingAllowedDomainList", alternate = {"SharingAllowedDomainList"})
    @Expose
	@Nullable
    public java.util.List<String> sharingAllowedDomainList;

    /**
     * The Sharing Blocked Domain List.
     * 
     */
    @SerializedName(value = "sharingBlockedDomainList", alternate = {"SharingBlockedDomainList"})
    @Expose
	@Nullable
    public java.util.List<String> sharingBlockedDomainList;

    /**
     * The Sharing Capability.
     * 
     */
    @SerializedName(value = "sharingCapability", alternate = {"SharingCapability"})
    @Expose
	@Nullable
    public SharingCapabilities sharingCapability;

    /**
     * The Sharing Domain Restriction Mode.
     * 
     */
    @SerializedName(value = "sharingDomainRestrictionMode", alternate = {"SharingDomainRestrictionMode"})
    @Expose
	@Nullable
    public SharingDomainRestrictionMode sharingDomainRestrictionMode;

    /**
     * The Site Creation Default Managed Path.
     * 
     */
    @SerializedName(value = "siteCreationDefaultManagedPath", alternate = {"SiteCreationDefaultManagedPath"})
    @Expose
	@Nullable
    public String siteCreationDefaultManagedPath;

    /**
     * The Site Creation Default Storage Limit In MB.
     * 
     */
    @SerializedName(value = "siteCreationDefaultStorageLimitInMB", alternate = {"SiteCreationDefaultStorageLimitInMB"})
    @Expose
	@Nullable
    public Integer siteCreationDefaultStorageLimitInMB;

    /**
     * The Tenant Default Timezone.
     * 
     */
    @SerializedName(value = "tenantDefaultTimezone", alternate = {"TenantDefaultTimezone"})
    @Expose
	@Nullable
    public String tenantDefaultTimezone;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
