// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.SimulationAttackTechnique;
import com.microsoft.graph.models.SimulationAttackType;
import com.microsoft.graph.models.EmailIdentity;
import com.microsoft.graph.models.PayloadDeliveryPlatform;
import com.microsoft.graph.models.SimulationReport;
import com.microsoft.graph.models.SimulationStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Simulation.
 */
public class Simulation extends Entity implements IJsonBackedObject {


    /**
     * The Attack Technique.
     * The social engineering technique used in the attack simulation and training campaign. Supports $filter and $orderby. Possible values are: unknown, credentialHarvesting, attachmentMalware, driveByUrl, linkInAttachment, linkToMalwareFile, unknownFutureValue. For more information on the types of social engineering attack techniques, see simulations.
     */
    @SerializedName(value = "attackTechnique", alternate = {"AttackTechnique"})
    @Expose
	@Nullable
    public SimulationAttackTechnique attackTechnique;

    /**
     * The Attack Type.
     * Attack type of the attack simulation and training campaign. Supports $filter and $orderby. Possible values are: unknown, social, cloud, endpoint, unknownFutureValue.
     */
    @SerializedName(value = "attackType", alternate = {"AttackType"})
    @Expose
	@Nullable
    public SimulationAttackType attackType;

    /**
     * The Automation Id.
     * Unique identifier for the attack simulation automation.
     */
    @SerializedName(value = "automationId", alternate = {"AutomationId"})
    @Expose
	@Nullable
    public String automationId;

    /**
     * The Completion Date Time.
     * Date and time of completion of the attack simulation and training campaign. Supports $filter and $orderby.
     */
    @SerializedName(value = "completionDateTime", alternate = {"CompletionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime completionDateTime;

    /**
     * The Created By.
     * Identity of the user who created the attack simulation and training campaign.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public EmailIdentity createdBy;

    /**
     * The Created Date Time.
     * Date and time of creation of the attack simulation and training campaign.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * Description of the attack simulation and training campaign.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Display name of the attack simulation and training campaign. Supports $filter and $orderby.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Is Automated.
     * Flag that represents if the attack simulation and training campaign was created from a simulation automation flow. Supports $filter and $orderby.
     */
    @SerializedName(value = "isAutomated", alternate = {"IsAutomated"})
    @Expose
	@Nullable
    public Boolean isAutomated;

    /**
     * The Last Modified By.
     * Identity of the user who most recently modified the attack simulation and training campaign.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public EmailIdentity lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * Date and time of the most recent modification of the attack simulation and training campaign.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Launch Date Time.
     * Date and time of the launch/start of the attack simulation and training campaign. Supports $filter and $orderby.
     */
    @SerializedName(value = "launchDateTime", alternate = {"LaunchDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime launchDateTime;

    /**
     * The Payload Delivery Platform.
     * Method of delivery of the phishing payload used in the attack simulation and training campaign. Possible values are: unknown, sms, email, teams, unknownFutureValue.
     */
    @SerializedName(value = "payloadDeliveryPlatform", alternate = {"PayloadDeliveryPlatform"})
    @Expose
	@Nullable
    public PayloadDeliveryPlatform payloadDeliveryPlatform;

    /**
     * The Report.
     * Report of the attack simulation and training campaign.
     */
    @SerializedName(value = "report", alternate = {"Report"})
    @Expose
	@Nullable
    public SimulationReport report;

    /**
     * The Status.
     * Status of the attack simulation and training campaign. Supports $filter and $orderby. Possible values are: unknown, draft, running, scheduled, succeeded, failed, cancelled, excluded, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public SimulationStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
