// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.AuthenticationStrengthPolicyType;
import com.microsoft.graph.models.AuthenticationStrengthRequirements;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AuthenticationCombinationConfigurationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Policy.
 */
public class AuthenticationStrengthPolicy extends Entity implements IJsonBackedObject {


    /**
     * The Allowed Combinations.
     * 
     */
    @SerializedName(value = "allowedCombinations", alternate = {"AllowedCombinations"})
    @Expose
	@Nullable
    public java.util.List<EnumSet<AuthenticationMethodModes>> allowedCombinations;

    /**
     * The Created Date Time.
     * 
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * 
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * 
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Modified Date Time.
     * 
     */
    @SerializedName(value = "modifiedDateTime", alternate = {"ModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime modifiedDateTime;

    /**
     * The Policy Type.
     * 
     */
    @SerializedName(value = "policyType", alternate = {"PolicyType"})
    @Expose
	@Nullable
    public AuthenticationStrengthPolicyType policyType;

    /**
     * The Requirements Satisfied.
     * 
     */
    @SerializedName(value = "requirementsSatisfied", alternate = {"RequirementsSatisfied"})
    @Expose
	@Nullable
    public EnumSet<AuthenticationStrengthRequirements> requirementsSatisfied;

    /**
     * The Combination Configurations.
     * 
     */
    @SerializedName(value = "combinationConfigurations", alternate = {"CombinationConfigurations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AuthenticationCombinationConfigurationCollectionPage combinationConfigurations;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("combinationConfigurations")) {
            combinationConfigurations = serializer.deserializeObject(json.get("combinationConfigurations"), com.microsoft.graph.requests.AuthenticationCombinationConfigurationCollectionPage.class);
        }
    }
}
