// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AuthenticationMethodModeDetailCollectionPage;
import com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Root.
 */
public class AuthenticationStrengthRoot extends Entity implements IJsonBackedObject {


    /**
     * The Combinations.
     * 
     */
    @SerializedName(value = "combinations", alternate = {"Combinations"})
    @Expose
	@Nullable
    public java.util.List<EnumSet<AuthenticationMethodModes>> combinations;

    /**
     * The Authentication Method Modes.
     * 
     */
    @SerializedName(value = "authenticationMethodModes", alternate = {"AuthenticationMethodModes"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AuthenticationMethodModeDetailCollectionPage authenticationMethodModes;

    /**
     * The Policies.
     * 
     */
    @SerializedName(value = "policies", alternate = {"Policies"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionPage policies;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("authenticationMethodModes")) {
            authenticationMethodModes = serializer.deserializeObject(json.get("authenticationMethodModes"), com.microsoft.graph.requests.AuthenticationMethodModeDetailCollectionPage.class);
        }

        if (json.has("policies")) {
            policies = serializer.deserializeObject(json.get("policies"), com.microsoft.graph.requests.AuthenticationStrengthPolicyCollectionPage.class);
        }
    }
}
