// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Enrollment Configuration Set Priority Parameter Set.
 */
public class DeviceEnrollmentConfigurationSetPriorityParameterSet {
    /**
     * The priority.
     * 
     */
    @SerializedName(value = "priority", alternate = {"Priority"})
    @Expose
	@Nullable
    public Integer priority;


    /**
     * Instiaciates a new DeviceEnrollmentConfigurationSetPriorityParameterSet
     */
    public DeviceEnrollmentConfigurationSetPriorityParameterSet() {}
    /**
     * Instiaciates a new DeviceEnrollmentConfigurationSetPriorityParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DeviceEnrollmentConfigurationSetPriorityParameterSet(@Nonnull final DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder builder) {
        this.priority = builder.priority;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder newBuilder() {
        return new DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder();
    }
    /**
     * Fluent builder for the DeviceEnrollmentConfigurationSetPriorityParameterSet
     */
    public static final class DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder {
        /**
         * The priority parameter value
         */
        @Nullable
        protected Integer priority;
        /**
         * Sets the Priority
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder withPriority(@Nullable final Integer val) {
            this.priority = val;
            return this;
        }
        /**
         * Instanciates a new DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder
         */
        @Nullable
        protected DeviceEnrollmentConfigurationSetPriorityParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DeviceEnrollmentConfigurationSetPriorityParameterSet build() {
            return new DeviceEnrollmentConfigurationSetPriorityParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.priority != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("priority", priority));
        }
        return result;
    }
}
