// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.DayOfWeek;
import com.microsoft.graph.models.TimeZoneBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Working Hours.
 */
public class WorkingHours implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Days Of Week.
     * The days of the week on which the user works.
     */
    @SerializedName(value = "daysOfWeek", alternate = {"DaysOfWeek"})
    @Expose
	@Nullable
    public java.util.List<DayOfWeek> daysOfWeek;

    /**
     * The End Time.
     * The time of the day that the user stops working.
     */
    @SerializedName(value = "endTime", alternate = {"EndTime"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.TimeOfDay endTime;

    /**
     * The Start Time.
     * The time of the day that the user starts working.
     */
    @SerializedName(value = "startTime", alternate = {"StartTime"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.TimeOfDay startTime;

    /**
     * The Time Zone.
     * The time zone to which the working hours apply.
     */
    @SerializedName(value = "timeZone", alternate = {"TimeZone"})
    @Expose
	@Nullable
    public TimeZoneBase timeZone;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
